/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk;

import android.content.Context;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Base64;
import android.util.Log;
import com.symbol.emdk.EMDKBase;
import com.symbol.emdk.EMDKManager;
import com.symbol.emdk.EMDKResults;
import com.symbol.emdk.EMDKServiceConnection;
import com.symbol.emdk.ProfileConfig;
import com.symbol.emdk.emdkservice.SvcProfileResult;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.InvalidParameterException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ProfileManager
extends EMDKBase {
    private static final String TAG = "Profile_Manager";
    private static String emdkConfigXml = "EMDKConfig.xml";
    private EMDKServiceConnection emdkServiceConnection = null;
    private Context context = null;
    Document doc = null;
    List<DataListener> dataListenerCallbacks = null;
    boolean isAsyncCall = false;
    boolean isPreviousRequestPending = false;

    ProfileManager(Context context, EMDKServiceConnection emdkServiceConnection) {
        super(EMDKManager.FEATURE_TYPE.PROFILE);
        this.context = context;
        this.emdkServiceConnection = emdkServiceConnection;
    }

    public boolean isPreviousRequestPending() {
        return this.isPreviousRequestPending;
    }

    public static String CreateNameValuePair(String emdkName, String paramName, String paramValue) {
        if (emdkName == null || emdkName.isEmpty()) {
            throw new InvalidParameterException("emdkName cannot be null or empty");
        }
        if (paramName == null || paramName.isEmpty()) {
            throw new InvalidParameterException("paramName cannot be null or empty");
        }
        if (paramValue == null) {
            throw new InvalidParameterException("paramValue cannot be null");
        }
        return emdkName + "." + paramName + "=" + paramValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EMDKResults processProfile(String profileName, PROFILE_FLAG profileFlag, Document extraData) {
        if (!this.isPreviousRequestPending || this.isPreviousRequestPending && this.isAsyncCall) {
            try {
                if (profileFlag == PROFILE_FLAG.GET && extraData == null) {
                    EMDKResults eMDKResults = new EMDKResults(EMDKResults.STATUS_CODE.NULL_POINTER, EMDKResults.EXTENDED_STATUS_CODE.INVALID_VALUE);
                    return eMDKResults;
                }
                if (profileName == null) {
                    EMDKResults eMDKResults = new EMDKResults(EMDKResults.STATUS_CODE.EMPTY_PROFILENAME);
                    return eMDKResults;
                }
                if (profileName.isEmpty()) {
                    EMDKResults eMDKResults = new EMDKResults(EMDKResults.STATUS_CODE.EMPTY_PROFILENAME);
                    return eMDKResults;
                }
                String[] strExtraData = new String[1];
                if (extraData != null) {
                    strExtraData[0] = this.getStringFromDocument(extraData);
                }
                EMDKResults emdkStatus = this.processProfile(profileName, profileFlag, strExtraData);
                if (extraData != null) {
                    Document newdoc = this.getDocumentFromString(strExtraData[0]);
                    NodeList nodes = extraData.getChildNodes();
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        extraData.removeChild(nodes.item(i));
                    }
                    if (newdoc != null) {
                        NodeList newnodes = newdoc.getChildNodes();
                        for (int j = 0; j < newnodes.getLength(); ++j) {
                            Node importedNode = extraData.importNode(newnodes.item(j), true);
                            extraData.appendChild(importedNode);
                        }
                    }
                }
                EMDKResults eMDKResults = emdkStatus;
                return eMDKResults;
            }
            finally {
                this.isPreviousRequestPending = false;
            }
        }
        return new EMDKResults(EMDKResults.STATUS_CODE.PREVIOUS_REQUEST_IN_PROGRESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EMDKResults processProfile(String profileName, PROFILE_FLAG profileFlag, String[] extraData) {
        if (this.isPreviousRequestPending) {
            if (!this.isPreviousRequestPending) return new EMDKResults(EMDKResults.STATUS_CODE.PREVIOUS_REQUEST_IN_PROGRESS);
            if (!this.isAsyncCall) return new EMDKResults(EMDKResults.STATUS_CODE.PREVIOUS_REQUEST_IN_PROGRESS);
        }
        this.isAsyncCall = false;
        this.isPreviousRequestPending = true;
        try {
            if (this.emdkServiceConnection == null || !this.emdkServiceConnection.isServiceConnected()) {
                if (extraData != null) {
                    extraData[0] = "";
                }
                EMDKResults eMDKResults = new EMDKResults(EMDKResults.STATUS_CODE.EMDK_NOT_OPENED, EMDKResults.EXTENDED_STATUS_CODE.DEPENDACY_COMPONENT_FAILURE);
                return eMDKResults;
            }
            if (profileName == null) {
                EMDKResults eMDKResults = new EMDKResults(EMDKResults.STATUS_CODE.EMPTY_PROFILENAME);
                return eMDKResults;
            }
            if (profileName.isEmpty()) {
                EMDKResults eMDKResults = new EMDKResults(EMDKResults.STATUS_CODE.EMPTY_PROFILENAME);
                return eMDKResults;
            }
            if (extraData != null && extraData[0] != null && extraData[0].isEmpty()) {
                extraData[0] = null;
            }
            EMDKResults results = new EMDKResults(EMDKResults.STATUS_CODE.FAILURE);
            String responseFromService = "";
            try {
                switch (profileFlag) {
                    case SET: {
                        responseFromService = extraData != null ? this.emdkServiceConnection.getService().setProfile(profileName, this.ArrayToEncodedeString(extraData)) : this.emdkServiceConnection.getService().setProfile(profileName, null);
                        results = new EMDKResults(responseFromService);
                        break;
                    }
                    case GET: {
                        if (extraData == null) {
                            EMDKResults eMDKResults = new EMDKResults(EMDKResults.STATUS_CODE.NULL_POINTER, EMDKResults.EXTENDED_STATUS_CODE.INVALID_VALUE);
                            return eMDKResults;
                        }
                        responseFromService = this.emdkServiceConnection.getService().getProfile(profileName);
                        if (responseFromService.startsWith("Failed,STATUS_CODE=")) {
                            String[] strResArr = responseFromService.split(",");
                            String exceptionMessaage = null;
                            EMDKResults.STATUS_CODE status = EMDKResults.STATUS_CODE.values()[Integer.parseInt(strResArr[1].replace("STATUS_CODE=", ""))];
                            EMDKResults.EXTENDED_STATUS_CODE extStatus = EMDKResults.EXTENDED_STATUS_CODE.values()[Integer.parseInt(strResArr[2].replace("EXTENDED_STATUS_CODE=", ""))];
                            if (strResArr.length > 3) {
                                exceptionMessaage = strResArr[3].replace("MESSAGE=", "");
                            }
                            results = new EMDKResults(status, extStatus, exceptionMessaage);
                            break;
                        }
                        extraData[0] = responseFromService;
                        results = new EMDKResults(EMDKResults.STATUS_CODE.SUCCESS);
                        break;
                    }
                    case RESET: {
                        String profileXml = this.readProfileXmlFile();
                        if (this.emdkServiceConnection.isServiceConnected()) {
                            boolean ret = this.emdkServiceConnection.getService().initializeProfileService(profileXml);
                            if (ret) {
                                results = new EMDKResults(EMDKResults.STATUS_CODE.SUCCESS);
                                break;
                            }
                            results = new EMDKResults(EMDKResults.STATUS_CODE.FAILURE);
                            break;
                        }
                        results = new EMDKResults(EMDKResults.STATUS_CODE.UNKNOWN, EMDKResults.EXTENDED_STATUS_CODE.DEPENDACY_COMPONENT_FAILURE);
                        break;
                    }
                    case CHECK_COMPATIBILITY: {
                        String extraXml = null;
                        if (extraData != null) {
                            extraXml = extraData[0];
                        }
                        SvcProfileResult result = this.emdkServiceConnection.getService().processProfileCompatibility(profileName, extraXml);
                        results = new EMDKResults(result);
                        break;
                    }
                }
            }
            catch (RemoteException e) {
                results = new EMDKResults(EMDKResults.STATUS_CODE.UNKNOWN, EMDKResults.EXTENDED_STATUS_CODE.DEPENDACY_COMPONENT_FAILURE);
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
            catch (Exception e) {
                results = new EMDKResults(EMDKResults.STATUS_CODE.FAILURE, EMDKResults.EXTENDED_STATUS_CODE.GENERAL_EXCEPTION_OCCURED, "Caught exception : " + e.getMessage());
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
            EMDKResults eMDKResults = results;
            return eMDKResults;
        }
        finally {
            this.isPreviousRequestPending = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public EMDKResults processProfile(String profileName, PROFILE_FLAG profileFlag, ProfileConfig extraData) {
        if (!this.isPreviousRequestPending || this.isPreviousRequestPending && this.isAsyncCall) {
            String responseFromService = "";
            EMDKResults results = new EMDKResults(EMDKResults.STATUS_CODE.FAILURE);
            try {
                if (profileFlag == PROFILE_FLAG.GET && extraData == null) {
                    EMDKResults eMDKResults = new EMDKResults(EMDKResults.STATUS_CODE.NULL_POINTER, EMDKResults.EXTENDED_STATUS_CODE.INVALID_VALUE);
                    return eMDKResults;
                }
                if (profileName == null || profileName.isEmpty()) {
                    EMDKResults eMDKResults = new EMDKResults(EMDKResults.STATUS_CODE.EMPTY_PROFILENAME);
                    return eMDKResults;
                }
                String[] extraXml = new String[1];
                try {
                    extraXml[0] = extraData.parseObjectToXML(profileName);
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("" + e.getMessage()));
                    EMDKResults eMDKResults = results = new EMDKResults(EMDKResults.STATUS_CODE.FAILURE, EMDKResults.EXTENDED_STATUS_CODE.INVALID_VALUE);
                    this.isPreviousRequestPending = false;
                    return eMDKResults;
                }
                results = this.processProfile(profileName, profileFlag, extraXml);
                try {
                    switch (profileFlag) {
                        case SET: {
                            if (results.statusCode != EMDKResults.STATUS_CODE.SUCCESS || extraData == null) break;
                            extraData.saveSettingsForComparison();
                            break;
                        }
                        case GET: {
                            if (results.statusCode != EMDKResults.STATUS_CODE.SUCCESS) break;
                            extraData.parseXMLToObject(profileName, extraXml[0]);
                            break;
                        }
                        case RESET: {
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    results = new EMDKResults(EMDKResults.STATUS_CODE.FAILURE, EMDKResults.EXTENDED_STATUS_CODE.GENERAL_EXCEPTION_OCCURED, "Caught exception : " + e.getMessage());
                    Log.e((String)TAG, (String)("" + e.getMessage()));
                }
                EMDKResults eMDKResults = results;
                return eMDKResults;
            }
            finally {
                this.isPreviousRequestPending = false;
            }
        }
        return new EMDKResults(EMDKResults.STATUS_CODE.PREVIOUS_REQUEST_IN_PROGRESS);
    }

    private String ArrayToEncodedeString(String[] stringArray) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            new ObjectOutputStream(out).writeObject(stringArray);
            return Base64.encodeToString((byte[])out.toByteArray(), (int)0);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String readProfileXmlFile() {
        StringBuilder sb = new StringBuilder();
        try {
            InputStream is = this.context.getAssets().open(emdkConfigXml);
            InputStreamReader reader = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(reader);
            String sCurrentLine = null;
            while ((sCurrentLine = br.readLine()) != null) {
                sb.append(sCurrentLine);
            }
        }
        catch (IOException e) {
            return "<?xml version=\"1.0\" encoding=\"utf-8\"?><wap-provisioningdoc></wap-provisioningdoc>";
        }
        return sb.toString();
    }

    private String getStringFromDocument(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException ex) {
            Log.e((String)TAG, (String)("" + ex.getMessage()));
            return null;
        }
    }

    private Document getDocumentFromString(String strDoc) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            Log.e((String)TAG, (String)("" + e1.getMessage()));
        }
        Document tdoc = null;
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(strDoc));
        try {
            if (db != null) {
                tdoc = db.parse(is);
            }
        }
        catch (SAXException e) {
            Log.e((String)TAG, (String)("" + e.getMessage()));
        }
        catch (IOException ex) {
            Log.e((String)TAG, (String)("" + ex.getMessage()));
        }
        return tdoc;
    }

    void release() {
        Log.d((String)TAG, (String)("releasing profile manager: isPreviousRequestPending = " + this.isPreviousRequestPending));
        this.emdkServiceConnection = null;
        this.context = null;
        this.doc = null;
    }

    public EMDKResults processProfileAsync(String profileName, PROFILE_FLAG profileFlag, Document extraData) {
        if (!this.emdkServiceConnection.isServiceConnected()) {
            return new EMDKResults(EMDKResults.STATUS_CODE.EMDK_NOT_OPENED, EMDKResults.EXTENDED_STATUS_CODE.DEPENDACY_COMPONENT_FAILURE);
        }
        if (this.dataListenerCallbacks == null) {
            return new EMDKResults(EMDKResults.STATUS_CODE.NO_DATA_LISTENER);
        }
        if (profileName == null) {
            return new EMDKResults(EMDKResults.STATUS_CODE.EMPTY_PROFILENAME);
        }
        if (profileName.isEmpty()) {
            return new EMDKResults(EMDKResults.STATUS_CODE.EMPTY_PROFILENAME);
        }
        if (this.isPreviousRequestPending) {
            return new EMDKResults(EMDKResults.STATUS_CODE.PREVIOUS_REQUEST_IN_PROGRESS);
        }
        this.isPreviousRequestPending = true;
        final String profileNameTemp = profileName;
        final PROFILE_FLAG profileFlagTemp = profileFlag;
        final Document extraDataTemp = extraData;
        Thread processProfileThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Looper.prepare();
                EMDKResults results = null;
                String[] extraDataLocal = null;
                try {
                    extraDataLocal = new String[1];
                    if (profileFlagTemp != PROFILE_FLAG.GET) {
                        extraDataLocal[0] = ProfileManager.this.getStringFromDocument(extraDataTemp);
                    }
                    ProfileManager.this.isAsyncCall = true;
                    results = ProfileManager.this.processProfile(profileNameTemp, profileFlagTemp, extraDataLocal);
                }
                catch (Exception ex) {
                    results = new EMDKResults(EMDKResults.STATUS_CODE.FAILURE, EMDKResults.EXTENDED_STATUS_CODE.GENERAL_EXCEPTION_OCCURED, "Caught exception : " + ex.getMessage());
                }
                ResultData resultData = profileFlagTemp != PROFILE_FLAG.GET ? new ResultData(profileNameTemp, profileFlagTemp, null, results) : new ResultData(profileNameTemp, profileFlagTemp, extraDataLocal[0], results);
                ProfileManager.this.isPreviousRequestPending = false;
                ProfileManager.this.isAsyncCall = false;
                ProfileManager.this.notifyResult(resultData);
                Looper.loop();
            }
        });
        processProfileThread.start();
        return new EMDKResults(EMDKResults.STATUS_CODE.PROCESSING);
    }

    public EMDKResults processProfileAsync(String profileName, PROFILE_FLAG profileFlag, String[] extraData) {
        if (!this.emdkServiceConnection.isServiceConnected()) {
            return new EMDKResults(EMDKResults.STATUS_CODE.EMDK_NOT_OPENED, EMDKResults.EXTENDED_STATUS_CODE.DEPENDACY_COMPONENT_FAILURE);
        }
        if (this.dataListenerCallbacks == null) {
            return new EMDKResults(EMDKResults.STATUS_CODE.NO_DATA_LISTENER);
        }
        if (profileName == null) {
            return new EMDKResults(EMDKResults.STATUS_CODE.EMPTY_PROFILENAME);
        }
        if (profileName.isEmpty()) {
            return new EMDKResults(EMDKResults.STATUS_CODE.EMPTY_PROFILENAME);
        }
        if (this.isPreviousRequestPending) {
            return new EMDKResults(EMDKResults.STATUS_CODE.PREVIOUS_REQUEST_IN_PROGRESS);
        }
        this.isPreviousRequestPending = true;
        final String profileNameTemp = profileName;
        final PROFILE_FLAG profileFlagTemp = profileFlag;
        final String[] extraDataTemp = extraData;
        Thread processProfileThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Looper.prepare();
                EMDKResults results = null;
                String[] extraDataLocal = null;
                try {
                    extraDataLocal = new String[1];
                    if (profileFlagTemp != PROFILE_FLAG.GET) {
                        extraDataLocal = extraDataTemp;
                    }
                    ProfileManager.this.isAsyncCall = true;
                    results = ProfileManager.this.processProfile(profileNameTemp, profileFlagTemp, extraDataLocal);
                }
                catch (Exception ex) {
                    results = new EMDKResults(EMDKResults.STATUS_CODE.FAILURE, EMDKResults.EXTENDED_STATUS_CODE.GENERAL_EXCEPTION_OCCURED, "Caught exception : " + ex.getMessage());
                }
                ResultData resultData = profileFlagTemp != PROFILE_FLAG.GET ? new ResultData(profileNameTemp, profileFlagTemp, null, results) : new ResultData(profileNameTemp, profileFlagTemp, extraDataLocal[0], results);
                ProfileManager.this.isPreviousRequestPending = false;
                ProfileManager.this.isAsyncCall = false;
                ProfileManager.this.notifyResult(resultData);
                Looper.loop();
            }
        });
        processProfileThread.start();
        EMDKResults results = new EMDKResults(EMDKResults.STATUS_CODE.PROCESSING);
        return results;
    }

    @Deprecated
    public EMDKResults processProfileAsync(String profileName, PROFILE_FLAG profileFlag, ProfileConfig extraData) {
        if (!this.emdkServiceConnection.isServiceConnected()) {
            return new EMDKResults(EMDKResults.STATUS_CODE.EMDK_NOT_OPENED, EMDKResults.EXTENDED_STATUS_CODE.DEPENDACY_COMPONENT_FAILURE);
        }
        if (this.dataListenerCallbacks == null) {
            return new EMDKResults(EMDKResults.STATUS_CODE.NO_DATA_LISTENER);
        }
        if (profileName == null) {
            return new EMDKResults(EMDKResults.STATUS_CODE.EMPTY_PROFILENAME);
        }
        if (profileName.isEmpty()) {
            return new EMDKResults(EMDKResults.STATUS_CODE.EMPTY_PROFILENAME);
        }
        if (this.isPreviousRequestPending) {
            return new EMDKResults(EMDKResults.STATUS_CODE.PREVIOUS_REQUEST_IN_PROGRESS);
        }
        this.isPreviousRequestPending = true;
        final String profileNameTemp = profileName;
        final PROFILE_FLAG profileFlagTemp = profileFlag;
        final ProfileConfig extraDataTemp = extraData;
        Thread processProfileThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Looper.prepare();
                EMDKResults results = null;
                String[] extraDataLocal = null;
                try {
                    extraDataLocal = new String[1];
                    if (profileFlagTemp != PROFILE_FLAG.GET) {
                        extraDataLocal[0] = extraDataTemp.parseObjectToXML(profileNameTemp);
                    }
                    ProfileManager.this.isAsyncCall = true;
                    results = ProfileManager.this.processProfile(profileNameTemp, profileFlagTemp, extraDataLocal);
                }
                catch (Exception ex) {
                    results = new EMDKResults(EMDKResults.STATUS_CODE.FAILURE, EMDKResults.EXTENDED_STATUS_CODE.GENERAL_EXCEPTION_OCCURED, "Caught exception : " + ex.getMessage());
                }
                ResultData resultData = profileFlagTemp != PROFILE_FLAG.GET ? new ResultData(profileNameTemp, profileFlagTemp, null, results) : new ResultData(profileNameTemp, profileFlagTemp, extraDataLocal[0], results);
                ProfileManager.this.isPreviousRequestPending = false;
                ProfileManager.this.isAsyncCall = false;
                ProfileManager.this.notifyResult(resultData);
                Looper.loop();
            }
        });
        processProfileThread.start();
        return new EMDKResults(EMDKResults.STATUS_CODE.PROCESSING);
    }

    public void addDataListener(DataListener listener) {
        if (this.dataListenerCallbacks == null) {
            this.dataListenerCallbacks = new CopyOnWriteArrayList<DataListener>();
        }
        this.dataListenerCallbacks.add(listener);
    }

    public void removeDataListener(DataListener listener) {
        if (this.dataListenerCallbacks != null) {
            this.dataListenerCallbacks.remove(listener);
            if (this.dataListenerCallbacks.size() == 0) {
                this.dataListenerCallbacks = null;
            }
        }
    }

    private void notifyResult(ResultData resultData) {
        for (DataListener callback : this.dataListenerCallbacks) {
            if (callback == null) continue;
            callback.onData(resultData);
        }
    }

    public class ResultData {
        EMDKResults results = null;
        String profileName = "";
        PROFILE_FLAG profileFlag;
        Document profileDataDocument = null;
        ProfileConfig profileDataConfigObj = null;
        String profileDataString = null;

        ResultData(String profileName, PROFILE_FLAG profileFlag, String profileDataString, EMDKResults results) {
            this.profileName = profileName;
            this.profileFlag = profileFlag;
            this.results = results;
            this.profileDataString = profileDataString;
        }

        public EMDKResults getResult() {
            return this.results;
        }

        public String getProfileName() {
            return this.profileName;
        }

        public PROFILE_FLAG getProfileFlag() {
            return this.profileFlag;
        }

        public String getProfileString() {
            return this.profileDataString;
        }

        public Document getProfileDocument() {
            if (this.profileDataDocument == null) {
                this.profileDataDocument = ProfileManager.this.getDocumentFromString(this.profileDataString);
            }
            return this.profileDataDocument;
        }

        @Deprecated
        public ProfileConfig getProfileConfig() {
            if (this.profileDataConfigObj == null) {
                this.profileDataConfigObj = new ProfileConfig();
                try {
                    this.profileDataConfigObj.parseXMLToObject(this.profileName, this.profileDataString);
                }
                catch (XPathExpressionException e) {
                    Log.e((String)ProfileManager.TAG, (String)("" + e.getMessage()));
                    this.profileDataConfigObj = null;
                }
            }
            return this.profileDataConfigObj;
        }
    }

    public static enum PROFILE_FLAG {
        SET,
        GET,
        RESET,
        CHECK_COMPATIBILITY;

    }

    public static interface DataListener {
        public void onData(ResultData var1);
    }
}

