/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.emdkservice.notification;

public enum NotificationResults {
    SUCCESS(0),
    DEVICE_NOT_CONNECTED(1),
    DEVICE_INVALID(2),
    DEVICE_NOT_ENABLED(3),
    DEVICE_ALREADY_ENABLED(4),
    FAILURE(5),
    INVALID_VALUE(6),
    FEATURE_NOT_SUPPORTED(7),
    UNDEFINED(255);

    private int id;
    private String discription;

    private NotificationResults(int id) {
        this.id = id;
    }

    public int getValue() {
        return this.id;
    }

    public String getDescription() {
        if (this.discription == null || this.discription.length() == 0) {
            return NotificationResults.getErrorDescription(this);
        }
        return this.discription;
    }

    void setValue(int id, String discription) {
        this.id = id;
        this.discription = discription;
    }

    static String getErrorDescription(NotificationResults errorCode) {
        String errDescription;
        switch (errorCode) {
            case SUCCESS: {
                errDescription = "Success.";
                break;
            }
            case FAILURE: {
                errDescription = "Failure.";
                break;
            }
            case DEVICE_INVALID: {
                errDescription = "Notification device is invalid.";
                break;
            }
            case DEVICE_NOT_CONNECTED: {
                errDescription = "Notification device is not connected.";
                break;
            }
            case DEVICE_NOT_ENABLED: {
                errDescription = "Notification device is not enabled.";
                break;
            }
            case DEVICE_ALREADY_ENABLED: {
                errDescription = "Notification device is already enabled.";
                break;
            }
            case INVALID_VALUE: {
                errDescription = "The value specified is invalid.";
                break;
            }
            case FEATURE_NOT_SUPPORTED: {
                errDescription = "Feature not supported.";
                break;
            }
            default: {
                errDescription = "Error code not defined.";
            }
        }
        return errDescription;
    }
}

