/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.emdkservice.smartcard;

import android.annotation.SuppressLint;
import java.util.HashMap;
import java.util.Map;

public enum SvcSmartcardResult {
    SUCCESS(0),
    FAILURE(1),
    INVALID_OBJECT(3),
    INVALID_VALUE(6),
    NFC_DISABLED(7),
    UNSUPPORTED_PROTOCOL(15),
    SAM_NOT_PRESENT(192),
    SMARTCARD_ALREADY_CONNECTED(14),
    SMARTCARD_CONNECTION_NOT_ESTABLISHED(170),
    TDA8029_DEVICE_NOT_FOUND(2),
    TDA8029_SERIAL_LRC_ERR(240),
    TDA8029_SERIAL_TIMOUT(255),
    TDA8029_CMD_FRAME_LOST(241),
    UNDEFINED(-1);

    private int id;
    private String discription = "";
    @SuppressLint(value={"UseSparseArrays"})
    private static Map<Integer, SvcSmartcardResult> map;

    private SvcSmartcardResult(int id) {
        this.id = id;
    }

    public static SvcSmartcardResult getSmartcardResult(int id) {
        return map.get(id);
    }

    public int getValue() {
        return this.id;
    }

    public String getDescription() {
        if (this.discription == null || this.discription.length() == 0) {
            return SvcSmartcardResult.getErrorDescription(this);
        }
        return this.discription;
    }

    public void setValue(int id, String discription) {
        this.id = id;
        this.discription = discription;
    }

    static String getErrorDescription(SvcSmartcardResult errorCode) {
        String errDescription = "";
        switch (errorCode) {
            case INVALID_VALUE: {
                errDescription = "Invalid Input Parameter";
                break;
            }
            case UNSUPPORTED_PROTOCOL: {
                errDescription = "Unsupported protocol type";
                break;
            }
            case SAM_NOT_PRESENT: {
                errDescription = "SAM not present: ";
                break;
            }
            case SMARTCARD_ALREADY_CONNECTED: {
                errDescription = "Connection not closed";
                break;
            }
            case NFC_DISABLED: {
                errDescription = "Nfc is disabled: ";
                break;
            }
            case SMARTCARD_CONNECTION_NOT_ESTABLISHED: {
                errDescription = "Connection not established";
                break;
            }
            case INVALID_OBJECT: {
                errDescription = "Invalid Object";
                break;
            }
            case TDA8029_CMD_FRAME_LOST: {
                errDescription = "Command frame has been lost";
                break;
            }
            case TDA8029_DEVICE_NOT_FOUND: {
                errDescription = "Device not found";
                break;
            }
            case TDA8029_SERIAL_LRC_ERR: {
                errDescription = "Serial LRC error";
                break;
            }
            case TDA8029_SERIAL_TIMOUT: {
                errDescription = "Serial Timeout";
                break;
            }
            case UNDEFINED: {
                errDescription = "Error code not defined";
            }
        }
        return errDescription;
    }

    static {
        map = new HashMap<Integer, SvcSmartcardResult>();
        for (SvcSmartcardResult smartcardResult : SvcSmartcardResult.values()) {
            map.put(smartcardResult.id, smartcardResult);
        }
    }
}

