/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.notification;

import android.annotation.SuppressLint;
import android.util.Log;
import com.symbol.emdk.notification.DeviceInfo;
import com.symbol.emdk.notification.NotificationManager;
import com.symbol.emdk.notification.NotificationResults;
import java.util.HashMap;
import java.util.Map;

@SuppressLint(value={"UseSparseArrays"})
class DeviceUtils {
    private static String TAG = "Device_Utils";
    private static Map<Integer, NotificationResults> notificationResultsLookUp;

    DeviceUtils() {
    }

    static NotificationResults getNotificationResult(int errCode) {
        NotificationResults results = notificationResultsLookUp.get(errCode);
        if (results == null) {
            return NotificationResults.UNDEFINED;
        }
        return results;
    }

    static void updateSupportedList(DeviceInfo di, boolean connectionState) {
        for (DeviceInfo deviceInfo : NotificationManager.notificationManager.supportedDevices) {
            if (!deviceInfo.friendlyName.equalsIgnoreCase(di.friendlyName)) continue;
            NotificationManager.notificationManager.supportedDevices.remove(deviceInfo);
            return;
        }
        di.isConnected = connectionState;
        NotificationManager.notificationManager.supportedDevices.add(di);
    }

    static {
        try {
            NotificationResults[] vals = NotificationResults.values();
            notificationResultsLookUp = new HashMap<Integer, NotificationResults>(vals.length);
            for (NotificationResults nfnRes : vals) {
                notificationResultsLookUp.put(nfnRes.getValue(), nfnRes);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("" + e.getMessage()));
        }
    }
}

