/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.notification;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.symbol.emdk.EMDKServiceConnection;
import com.symbol.emdk.emdkservice.notification.SvcNotification;
import com.symbol.emdk.emdkservice.notification.SvcNotificationDeviceInfo;
import com.symbol.emdk.notification.DeviceInfo;
import com.symbol.emdk.notification.DeviceUtils;
import com.symbol.emdk.notification.Notification;
import com.symbol.emdk.notification.NotificationException;
import com.symbol.emdk.notification.NotificationManager;
import com.symbol.emdk.notification.NotificationResults;

public class NotificationDevice {
    private String TAG = "Notification_Device";
    DeviceInfo deviceInfo = null;
    private Context context;
    EMDKServiceConnection emdkServiceConnection = null;

    NotificationDevice(DeviceInfo deviceInfo, Context context, EMDKServiceConnection emdkServiceConnection) {
        this.deviceInfo = deviceInfo;
        this.context = context;
        this.emdkServiceConnection = emdkServiceConnection;
    }

    public DeviceInfo getDeviceInfo() {
        Log.i((String)this.TAG, (String)"#EMDK-API# NotificationDevice::getDeviceInfo()");
        try {
            SvcNotificationDeviceInfo devInfo = this.emdkServiceConnection.getService().nfnGetDeviceInfo(this.deviceInfo.deviceIndex);
            this.deviceInfo.updateDeviceInfo(devInfo);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("#EMDK-API# Caught exception : " + e.getMessage()));
        }
        return this.deviceInfo;
    }

    public boolean isConnected() {
        Log.i((String)this.TAG, (String)"#EMDK-API# NotificationDevice::isConnected()");
        Boolean retValue = false;
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().nfnIsConnected(this.deviceInfo.deviceIndex);
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)("#EMDK-API# Caught exception : " + e.getMessage()));
            }
        }
        return retValue;
    }

    public boolean isEnabled() {
        Log.i((String)this.TAG, (String)"#EMDK-API# NotificationDevice::isEnabled()");
        Boolean retValue = false;
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().nfnIsEnabled(this.deviceInfo.deviceIndex);
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)("#EMDK-API# Caught exception : " + e.getMessage()));
            }
        }
        return retValue;
    }

    public void enable() throws NotificationException {
        Log.i((String)this.TAG, (String)"#EMDK-API# NotificationDevice::enable()");
        int retValue = NotificationResults.FAILURE.getValue();
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().nfnEnable(this.deviceInfo.deviceIndex);
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)("#EMDK-API# Caught exception : " + e.getMessage()));
            }
        }
        if (NotificationResults.SUCCESS.getValue() != retValue) {
            throw new NotificationException(DeviceUtils.getNotificationResult(retValue), retValue);
        }
    }

    public void disable() throws NotificationException {
        Log.i((String)this.TAG, (String)"#EMDK-API# NotificationDevice::disable()");
        int retValue = NotificationResults.FAILURE.getValue();
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().nfnDisable(this.deviceInfo.deviceIndex);
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)("#EMDK-API# Caught exception : " + e.getMessage()));
            }
        }
        if (NotificationResults.SUCCESS.getValue() != retValue) {
            throw new NotificationException(DeviceUtils.getNotificationResult(retValue), retValue);
        }
    }

    public void notify(Notification notification) throws NotificationException {
        Log.i((String)this.TAG, (String)"#EMDK-API# notify() [Start]");
        int retValue = NotificationResults.FAILURE.getValue();
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                SvcNotification.Notification notif = this.updateParameters(notification);
                SvcNotification svcNotif = new SvcNotification(notif, this.deviceInfo.deviceIndex);
                retValue = this.emdkServiceConnection.getService().nfnNotify(svcNotif);
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)("#EMDK-API# notify() Exception: " + e.getMessage()));
            }
            if (NotificationResults.SUCCESS.getValue() != retValue) {
                throw new NotificationException(DeviceUtils.getNotificationResult(retValue), retValue);
            }
        } else {
            Log.e((String)this.TAG, (String)"#EMDK-API# notify() Service is not connected");
        }
        Log.i((String)this.TAG, (String)"#EMDK-API# notify() [Finish]");
    }

    public void cancelNotification() throws NotificationException {
        Log.i((String)this.TAG, (String)"#EMDK-API# cancelNotification() [Start]");
        int retValue = NotificationResults.FAILURE.getValue();
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().nfnCancelNotification(this.deviceInfo.deviceIndex);
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)("#EMDK-API# cancelNotification() Exception: " + e.getMessage()));
            }
            if (NotificationResults.SUCCESS.getValue() != retValue) {
                throw new NotificationException(DeviceUtils.getNotificationResult(retValue), retValue);
            }
        } else {
            Log.e((String)this.TAG, (String)"#EMDK-API# cancelNotification() Service is not connected");
        }
        Log.i((String)this.TAG, (String)"#EMDK-API# cancelNotification() [Finish]");
    }

    SvcNotification.Notification updateParameters(Notification notification) {
        Log.i((String)this.TAG, (String)"#EMDK-API# updateParameters() [Start]");
        SvcNotification.Notification notif = new SvcNotification.Notification();
        notif.led.color = notification.led.color;
        notif.led.onTime = notification.led.onTime;
        notif.led.offTime = notification.led.offTime;
        notif.led.repeatCount = notification.led.repeatCount;
        if (notification.beep.pattern != null) {
            notif.beep.pattern = new SvcNotification.Beep[notification.beep.pattern.length];
            for (int i = 0; i < notification.beep.pattern.length; ++i) {
                notif.beep.pattern[i] = new SvcNotification.Beep();
                notif.beep.pattern[i].time = notification.beep.pattern[i].time;
                notif.beep.pattern[i].frequency = notification.beep.pattern[i].frequency;
            }
        }
        notif.vibrate.time = notification.vibrate.time;
        notif.vibrate.pattern = notification.vibrate.pattern;
        Log.i((String)this.TAG, (String)"#EMDK-API# updateParameters() [Finish]");
        return notif;
    }

    public void release() throws NotificationException {
        int retValue = NotificationResults.FAILURE.getValue();
        Log.i((String)this.TAG, (String)"#EMDK-API# NotificationDevice::release() [Start]");
        NotificationManager.createdDevices.remove(this);
        if (this.emdkServiceConnection != null && this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().nfnRelease(this.deviceInfo.deviceIndex);
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)("" + e.getMessage()));
            }
        }
        if (NotificationResults.SUCCESS.getValue() != retValue) {
            throw new NotificationException(DeviceUtils.getNotificationResult(retValue), retValue);
        }
        Log.i((String)this.TAG, (String)"#EMDK-API# NotificationDevice::release() [Finish]");
    }

    public Bundle getParams(Bundle parameters) throws NotificationException {
        int errorCode = NotificationResults.FAILURE.getValue();
        Bundle retValue = new Bundle();
        Log.i((String)this.TAG, (String)"#EMDK-API# NotificationDevice::getParams() [Start]");
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().nfnGetParams(this.deviceInfo.deviceIndex, parameters);
                errorCode = retValue.getInt("ERROR_CODE");
            }
            catch (Exception e) {
                Log.d((String)this.TAG, (String)("#EMDK-API# NotificationDevice error in getParams() " + e.getMessage()));
            }
            if (NotificationResults.SUCCESS.getValue() != errorCode) {
                throw new NotificationException(DeviceUtils.getNotificationResult(errorCode), errorCode);
            }
        } else {
            Log.e((String)this.TAG, (String)"#EMDK-API# getParams() Service is not connected");
        }
        Log.i((String)this.TAG, (String)"#EMDK-API# NotificationDevice::getParams() [Finish]");
        return retValue.getBundle("PARAM_BUNDLE");
    }

    public void setParams(Bundle parameters) throws NotificationException {
        int retValue = NotificationResults.FAILURE.getValue();
        Log.i((String)this.TAG, (String)"#EMDK-API# NotificationDevice::setParams() [Start]");
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().nfnSetParams(this.deviceInfo.deviceIndex, parameters);
            }
            catch (Exception e) {
                Log.d((String)this.TAG, (String)("#EMDK-API# NotificationDevice error in setParams() " + e.getMessage()));
            }
            if (NotificationResults.SUCCESS.getValue() != retValue) {
                throw new NotificationException(DeviceUtils.getNotificationResult(retValue), retValue);
            }
        } else {
            Log.e((String)this.TAG, (String)"#EMDK-API# setParams() Service is not connected");
        }
        Log.i((String)this.TAG, (String)"#EMDK-API# NotificationDevice::setParams() [Finish]");
    }

    public void startBeaconing(Bundle parameters) throws NotificationException {
        int retValue = NotificationResults.FAILURE.getValue();
        Log.i((String)this.TAG, (String)"#EMDK-API# NotificationDevice::startBeaconing() [Start]");
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().nfnStartBeaconing(this.deviceInfo.deviceIndex, parameters);
            }
            catch (Exception e) {
                Log.d((String)this.TAG, (String)("#EMDK-API# NotificationDevice error in startBeaconing() " + e.getMessage()));
            }
            if (NotificationResults.SUCCESS.getValue() != retValue) {
                throw new NotificationException(DeviceUtils.getNotificationResult(retValue), retValue);
            }
        } else {
            Log.e((String)this.TAG, (String)"#EMDK-API# startBeaconing() Service is not connected");
        }
        Log.i((String)this.TAG, (String)"#EMDK-API# NotificationDevice::startBeaconing() [Finish]");
    }

    public void stopBeaconing(Bundle parameters) throws NotificationException {
        int retValue = NotificationResults.FAILURE.getValue();
        Log.i((String)this.TAG, (String)"#EMDK-API# NotificationDevice::stopBeaconing() [Start]");
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retValue = this.emdkServiceConnection.getService().nfnStopBeaconing(this.deviceInfo.deviceIndex, parameters);
            }
            catch (Exception e) {
                Log.d((String)this.TAG, (String)("#EMDK-API# NotificationDevice error in stopBeaconing() " + e.getMessage()));
            }
            if (NotificationResults.SUCCESS.getValue() != retValue) {
                throw new NotificationException(DeviceUtils.getNotificationResult(retValue), retValue);
            }
        } else {
            Log.e((String)this.TAG, (String)"#EMDK-API# stopBeaconing() Service is not connected");
        }
        Log.i((String)this.TAG, (String)"#EMDK-API# NotificationDevice::stopBeaconing() [Finish]");
    }
}

