/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.notification;

import android.content.Context;
import android.os.RemoteException;
import android.util.Log;
import com.symbol.emdk.EMDKBase;
import com.symbol.emdk.EMDKManager;
import com.symbol.emdk.EMDKServiceConnection;
import com.symbol.emdk.emdkservice.notification.SvcNotificationDeviceInfo;
import com.symbol.emdk.notification.DeviceInfo;
import com.symbol.emdk.notification.NotificationConnectionCallbackInternal;
import com.symbol.emdk.notification.NotificationDevice;
import com.symbol.emdk.notification.NotificationException;
import com.symbol.emdk.notification.NotificationResults;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class NotificationManager
extends EMDKBase {
    private static String TAG = "Notification_Manager";
    static NotificationManager notificationManager = null;
    Context context;
    EMDKServiceConnection emdkServiceConnection;
    ArrayList<DeviceInfo> supportedDevices;
    static List<NotificationDevice> createdDevices = new CopyOnWriteArrayList<NotificationDevice>();
    List<NotificationDeviceConnectionListener> notificationDeviceConnectionListeners;
    NotificationConnectionCallbackInternal notificationConnectionCallbackInternal;

    NotificationManager(Context context, EMDKServiceConnection emdkServiceConnection) throws NotificationException {
        block6: {
            super(EMDKManager.FEATURE_TYPE.NOTIFICATION);
            this.context = null;
            this.emdkServiceConnection = null;
            this.supportedDevices = new ArrayList();
            this.notificationDeviceConnectionListeners = null;
            this.notificationConnectionCallbackInternal = null;
            Log.i((String)TAG, (String)"#EMDK-API# NotificationManager::NotificationManager()");
            if (emdkServiceConnection == null || !emdkServiceConnection.isServiceConnected()) {
                throw new NotificationException(NotificationResults.FAILURE);
            }
            this.emdkServiceConnection = emdkServiceConnection;
            this.context = context;
            try {
                if (0 == this.emdkServiceConnection.getService().nfnInitialize()) {
                    List<SvcNotificationDeviceInfo> temp = this.emdkServiceConnection.getService().nfnGetSupportedDevicesInfo();
                    for (SvcNotificationDeviceInfo deviceInfo : temp) {
                        this.supportedDevices.add(new DeviceInfo(deviceInfo));
                    }
                    if (this.supportedDevices.isEmpty()) {
                        Log.e((String)TAG, (String)"#EMDK-API# No Notification supported devices");
                        throw new NotificationException(NotificationResults.FAILURE);
                    }
                    break block6;
                }
                throw new NotificationException(NotificationResults.FAILURE);
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
                throw new NotificationException(NotificationResults.FAILURE);
            }
        }
        notificationManager = this;
        this.registerConnectionNotification();
    }

    void release() {
        Log.i((String)TAG, (String)"#EMDK-API# NotificationManager::release()");
        if (createdDevices != null) {
            for (NotificationDevice device : createdDevices) {
                try {
                    device.release();
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("" + e.getMessage()));
                }
            }
            createdDevices.clear();
        }
        if (this.notificationDeviceConnectionListeners != null) {
            this.notificationDeviceConnectionListeners.clear();
            this.notificationDeviceConnectionListeners = null;
        }
        this.unRegisterConnectionNotification();
        if (this.emdkServiceConnection != null && this.emdkServiceConnection.isServiceConnected()) {
            try {
                this.emdkServiceConnection.getService().nfnUnInitialize();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
    }

    public List<DeviceInfo> getSupportedDevicesInfo() {
        block4: {
            Log.i((String)TAG, (String)"#EMDK-API# NotificationManager::getSupportedDevicesInfo()");
            try {
                if (this.emdkServiceConnection.isServiceConnected()) {
                    this.supportedDevices.clear();
                    List<SvcNotificationDeviceInfo> tempList = this.emdkServiceConnection.getService().nfnGetSupportedDevicesInfo();
                    for (SvcNotificationDeviceInfo devInfo : tempList) {
                        this.supportedDevices.add(new DeviceInfo(devInfo));
                    }
                    break block4;
                }
                throw new NotificationException(NotificationResults.FAILURE);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("#EMDK-API# Caught exception : " + e.getMessage()));
            }
        }
        return this.supportedDevices;
    }

    public NotificationDevice getDevice(DeviceInfo deviceInfo) throws NotificationException {
        Log.i((String)TAG, (String)"#EMDK-API# NotificationManager::getDevice(DeviceInfo deviceInfo)");
        if (deviceInfo != null) {
            for (DeviceInfo temp : this.supportedDevices) {
                if (temp.deviceIndex != deviceInfo.deviceIndex) continue;
                return this.getDeviceInternal(deviceInfo);
            }
        }
        return null;
    }

    public NotificationDevice getDevice(DeviceIdentifier deviceIdentifier) throws NotificationException {
        Log.i((String)TAG, (String)"#EMDK-API# NotificationManager::getDevice(DeviceIdentifier deviceIdentifier)");
        NotificationDevice device = null;
        boolean index = false;
        switch (deviceIdentifier) {
            case DEFAULT: {
                for (DeviceInfo deviceInfo : this.supportedDevices) {
                    if (!deviceInfo.isDefaultDevice) continue;
                    return this.getDeviceInternal(deviceInfo);
                }
                break;
            }
            default: {
                device = this.getDeviceByIdentifier(deviceIdentifier);
            }
        }
        if (device == null) {
            Log.e((String)TAG, (String)"#EMDK-API# Specified device is not found.");
        }
        return device;
    }

    private NotificationDevice getDeviceByIdentifier(DeviceIdentifier deviceIdentifier) {
        for (DeviceInfo deviceInfo : this.supportedDevices) {
            if (deviceInfo.deviceIdentifier != deviceIdentifier) continue;
            return this.getDeviceInternal(deviceInfo);
        }
        return null;
    }

    private NotificationDevice getDeviceInternal(DeviceInfo deviceInfo) {
        for (NotificationDevice device : createdDevices) {
            if (device.deviceInfo.deviceIndex != deviceInfo.deviceIndex) continue;
            return device;
        }
        NotificationDevice device = null;
        if (this.emdkServiceConnection != null && this.emdkServiceConnection.isServiceConnected()) {
            try {
                Log.i((String)TAG, (String)"#EMDK-API# NotificationManager::getDeviceInternal() Getting from service");
                if (0 == this.emdkServiceConnection.getService().nfnGetDevice(deviceInfo.deviceIndex)) {
                    device = new NotificationDevice(deviceInfo, this.context, this.emdkServiceConnection);
                    createdDevices.add(device);
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
        return device;
    }

    private void registerConnectionNotification() {
        if (this.notificationConnectionCallbackInternal == null) {
            this.notificationConnectionCallbackInternal = new NotificationConnectionCallbackInternal(this);
            try {
                this.emdkServiceConnection.getService().nfnAddConnectionListener(this.notificationConnectionCallbackInternal);
            }
            catch (RemoteException e) {
                Log.d((String)TAG, (String)("Caught exception : " + e.getMessage()));
            }
        }
    }

    private void unRegisterConnectionNotification() {
        if (this.notificationConnectionCallbackInternal != null) {
            if (this.emdkServiceConnection.isServiceConnected()) {
                try {
                    this.emdkServiceConnection.getService().nfnRemoveConectionListener(this.notificationConnectionCallbackInternal);
                }
                catch (RemoteException e) {
                    Log.d((String)TAG, (String)"Caught remote exception");
                    Log.e((String)TAG, (String)("" + e.getMessage()));
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("" + e.getMessage()));
                }
            }
            this.notificationConnectionCallbackInternal = null;
        }
    }

    public void addConnectionListener(NotificationDeviceConnectionListener connectionListener) {
        if (this.notificationDeviceConnectionListeners == null) {
            this.notificationDeviceConnectionListeners = new CopyOnWriteArrayList<NotificationDeviceConnectionListener>();
        }
        this.notificationDeviceConnectionListeners.add(connectionListener);
    }

    public void removeConnectionListener(NotificationDeviceConnectionListener connectionListener) {
        if (this.notificationDeviceConnectionListeners != null) {
            this.notificationDeviceConnectionListeners.remove(connectionListener);
            if (this.notificationDeviceConnectionListeners.size() <= 0) {
                this.notificationDeviceConnectionListeners = null;
            }
        }
    }

    public static enum DeviceIdentifier {
        DEFAULT(0),
        BLUETOOTH_IMAGER_RS6000(1),
        EXTERNAL_VIBRATOR1(2),
        BLUETOOTH_IMAGER_RS5100(3),
        BLUETOOTH_GENERIC(4);

        private final int id;

        private DeviceIdentifier(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }

    public static enum ConnectionState {
        CONNECTED,
        DISCONNECTED;

    }

    public static interface NotificationDeviceConnectionListener {
        public void onConnectionChange(DeviceInfo var1, ConnectionState var2);
    }
}

