/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.personalshopper;

import android.util.Log;
import com.symbol.emdk.EMDKServiceConnection;
import com.symbol.emdk.emdkservice.cradle.SvcCradleLocation;
import com.symbol.emdk.emdkservice.cradle.SvcCradleResults;
import com.symbol.emdk.personalshopper.CradleException;
import com.symbol.emdk.personalshopper.CradleResults;

public class CradleConfig {
    private static final String TAG = "Cradle_Config";
    EMDKServiceConnection emdkServiceConnection = null;
    boolean isReleased = false;

    CradleConfig(EMDKServiceConnection emdkServiceConnection) {
        this.emdkServiceConnection = emdkServiceConnection;
    }

    public CradleLocation getLocation() throws CradleException {
        SvcCradleLocation SvcCradleLocation2 = null;
        CradleLocation location = null;
        if (this.isReleased) {
            throw new CradleException(CradleResults.FAILURE);
        }
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                SvcCradleLocation2 = this.emdkServiceConnection.getService().crdConfigGetCradleLocation();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
                throw new CradleException(CradleResults.FAILURE);
            }
        }
        if (null != SvcCradleLocation2) {
            if (SvcCradleLocation2.wall == -1 && SvcCradleLocation2.row == -1 && SvcCradleLocation2.column == -1) {
                throw new CradleException(CradleResults.FAILURE);
            }
            try {
                location = new CradleLocation(SvcCradleLocation2.wall, SvcCradleLocation2.row, SvcCradleLocation2.column);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        } else {
            throw new CradleException(CradleResults.NOT_ENABLED);
        }
        return location;
    }

    public int setLocation(CradleLocation cradleLocation) throws CradleException {
        SvcCradleLocation svcCradleLocation = new SvcCradleLocation();
        int retval = SvcCradleResults.FAILURE.getValue();
        if (this.isReleased) {
            throw new CradleException(CradleResults.FAILURE);
        }
        if (cradleLocation == null) {
            throw new CradleException(CradleResults.INVALID_VALUE);
        }
        if (svcCradleLocation != null) {
            svcCradleLocation.column = cradleLocation.column;
            svcCradleLocation.row = cradleLocation.row;
            svcCradleLocation.wall = cradleLocation.wall;
        }
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retval = this.emdkServiceConnection.getService().crdConfigSetLocation(svcCradleLocation);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
                throw new CradleException(CradleResults.FAILURE);
            }
        }
        if (SvcCradleResults.SUCCESS.getValue() != retval) {
            if (retval == SvcCradleResults.NOT_ENABLED.getValue()) {
                throw new CradleException(CradleResults.NOT_ENABLED);
            }
            throw new CradleException(CradleResults.FAILURE);
        }
        return retval;
    }

    public int setFastChargingState(boolean isFastChargingState) throws CradleException {
        int retval = SvcCradleResults.FAILURE.getValue();
        if (this.isReleased) {
            throw new CradleException(CradleResults.FAILURE);
        }
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                retval = this.emdkServiceConnection.getService().crdConfigSetFCState(isFastChargingState);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
                throw new CradleException(CradleResults.FAILURE);
            }
        }
        if (SvcCradleResults.SUCCESS.getValue() != retval) {
            if (retval == SvcCradleResults.NOT_ENABLED.getValue()) {
                throw new CradleException(CradleResults.NOT_ENABLED);
            }
            throw new CradleException(CradleResults.FAILURE);
        }
        return retval;
    }

    public boolean getFastChargingState() throws CradleException {
        boolean fcState = false;
        if (this.isReleased) {
            throw new CradleException(CradleResults.FAILURE);
        }
        if (this.emdkServiceConnection.isServiceConnected()) {
            try {
                fcState = this.emdkServiceConnection.getService().crdConfigGetFCState();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
                throw new CradleException(CradleResults.FAILURE);
            }
        }
        return fcState;
    }

    public class CradleLocation {
        public int wall = -1;
        public int row = -1;
        public int column = -1;

        public CradleLocation(int wall, int row, int column) {
            this.wall = wall;
            this.row = row;
            this.column = column;
        }
    }
}

