/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.personalshopper;

import android.content.Context;
import android.util.Log;
import com.symbol.emdk.EMDKServiceConnection;
import com.symbol.emdk.emdkservice.diagnostic.SvcDiagnosticConfig;
import com.symbol.emdk.emdkservice.diagnostic.SvcDiagnosticData;
import com.symbol.emdk.personalshopper.DiagnosticConfig;
import com.symbol.emdk.personalshopper.DiagnosticData;
import com.symbol.emdk.personalshopper.DiagnosticException;
import com.symbol.emdk.personalshopper.DiagnosticResults;

public class Diagnostic {
    private static final String TAG = "Diagnostic";
    private Context context = null;
    private EMDKServiceConnection emdkServiceConnection = null;
    private boolean isReleased = false;

    Diagnostic(Context context, EMDKServiceConnection emdkServiceConnection) {
        this.context = context;
        this.emdkServiceConnection = emdkServiceConnection;
    }

    public DiagnosticData getDiagnosticData(int paramId, DiagnosticConfig diagnosticconfig) throws DiagnosticException {
        SvcDiagnosticData svcDiagnosticData = null;
        DiagnosticData diagnosticdata = null;
        if (this.isReleased) {
            Log.e((String)TAG, (String)"Diagnostic object already released");
            throw new DiagnosticException(DiagnosticResults.INVALID_OBJECT);
        }
        if (this.emdkServiceConnection.isServiceConnected()) {
            if (diagnosticconfig == null) {
                Log.e((String)TAG, (String)"flashLed DiagnosticConfig is null");
                throw new DiagnosticException(DiagnosticResults.INVALID_OBJECT);
            }
            if (paramId <= 0) {
                Log.e((String)TAG, (String)"Param ID in Diagnostic is 0 or negative");
                throw new DiagnosticException(DiagnosticResults.INVALID_VALUE);
            }
            SvcDiagnosticConfig svcDiagnosticConfig = new SvcDiagnosticConfig(diagnosticconfig.averageCurrent, diagnosticconfig.tripInMinutes);
            try {
                svcDiagnosticData = this.emdkServiceConnection.getService().diagGetDiagnosticData(paramId, svcDiagnosticConfig);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
                throw new DiagnosticException(DiagnosticResults.FAILURE);
            }
        }
        if (svcDiagnosticData == null) {
            throw new DiagnosticException(DiagnosticResults.INVALID_VALUE);
        }
        diagnosticdata = new DiagnosticData(svcDiagnosticData);
        return diagnosticdata;
    }

    void release() throws DiagnosticException {
        if (this.isReleased) {
            Log.e((String)TAG, (String)"Diagnostic object already released");
            throw new DiagnosticException(DiagnosticResults.INVALID_OBJECT);
        }
        this.isReleased = true;
    }
}

