/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.sam;

import android.os.RemoteException;
import android.util.Log;
import com.symbol.emdk.emdkservice.IEMDKService;
import com.symbol.emdk.emdkservice.sam.SvcAPDUData;
import com.symbol.emdk.emdkservice.sam.SvcAPDUResult;
import com.symbol.emdk.emdkservice.sam.SvcSAMInfo;
import com.symbol.emdk.sam.SAMException;
import com.symbol.emdk.sam.SAMManager;
import com.symbol.emdk.sam.SAMManagerHelper;
import com.symbol.emdk.sam.SAMResults;
import com.symbol.emdk.sam.SAMType;

public class SAM {
    private static final String TAG = "SAM";
    private SAMType samType = SAMType.UNKNOWN;
    private boolean isSAMConnected = false;
    private int samIndex = 0;
    private IEMDKService emdkService = null;
    SAMManager samManager = null;

    SAM(SAMManager samManager, SvcSAMInfo info) {
        this.emdkService = samManager.getEmdkService();
        this.samManager = samManager;
        this.samIndex = info.getSamIndex();
        if (info.getSamType() == SAMType.MIFARE.getVal()) {
            this.samType = SAMType.MIFARE;
        }
        if (info.getSamType() == SAMType.CALYPSO.getVal()) {
            this.samType = SAMType.CALYPSO;
        }
        if (info.getSamType() == SAMType.FELICA.getVal()) {
            this.samType = SAMType.FELICA;
        }
    }

    public void connect() throws SAMException {
        long tick = System.currentTimeMillis();
        try {
            int result = this.emdkService.samConnect(this.samIndex);
            if (result != SAMResults.SUCCESS.getVal()) {
                throw new SAMException(SAMManagerHelper.mapCode(result));
            }
            this.isSAMConnected = true;
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("" + e.getMessage()));
        }
        Log.d((String)TAG, (String)("connect took : " + (System.currentTimeMillis() - tick)));
    }

    public void disconnect() {
        long tick = System.currentTimeMillis();
        try {
            this.emdkService.samClose(this.samIndex);
            this.isSAMConnected = false;
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("" + e.getMessage()));
        }
        Log.d((String)TAG, (String)("SAMManager.close took : " + (System.currentTimeMillis() - tick)));
    }

    public byte[] transceive(byte[] apdu, short responseLength, boolean userFormattedProtocolFrame) throws SAMException {
        long tick = System.currentTimeMillis();
        if (apdu == null) {
            throw new SAMException(SAMResults.INVALID_APDU_COMMAND);
        }
        if (this.emdkService != null) {
            SvcAPDUData apduData = new SvcAPDUData();
            apduData.apdu = apdu;
            apduData.resultLength = responseLength;
            apduData.formattedProtocol = userFormattedProtocolFrame;
            SvcAPDUResult apduResult = null;
            try {
                apduResult = this.emdkService.samTransceive(this.samIndex, apduData);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
            if (apduResult.status != SAMResults.SUCCESS.getVal()) {
                throw new SAMException(SAMManagerHelper.mapCode(apduResult.status));
            }
            Log.d((String)TAG, (String)("transceive took : " + (System.currentTimeMillis() - tick)));
            return apduResult.apdu_result_data;
        }
        throw new SAMException(SAMResults.FAILURE);
    }

    public boolean isConnected() {
        return this.isSAMConnected;
    }

    public SAMType getSamType() {
        return this.samType;
    }

    public int getSamIndex() {
        return this.samIndex;
    }

    public byte[] getSmartCardATR() throws SAMException {
        byte[] atr = null;
        try {
            atr = this.emdkService.getSmartCardATR();
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("" + e.getMessage()));
        }
        if (atr == null) {
            throw new SAMException(SAMResults.FAILURE);
        }
        return atr;
    }

    public int setSmartCardPPS(byte fd, byte protocol) throws SAMException {
        int retVal = -1;
        try {
            retVal = this.emdkService.setSmartCardPPS(fd, protocol);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("" + e.getMessage()));
            throw new SAMException(SAMResults.FAILURE);
        }
        return retVal;
    }
}

