/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.sam;

import android.content.Context;
import android.util.Log;
import com.symbol.emdk.EMDKServiceConnection;
import com.symbol.emdk.sam.SAMManager;
import com.symbol.emdk.sam.SAMResults;
import java.util.HashMap;
import java.util.Map;

public class SAMManagerHelper {
    private static final String TAG = "SAM_Manager_Helper";
    private static Map<Integer, SAMResults> samResultsLookUp;

    public static SAMManager getInstance(Context context, EMDKServiceConnection emdkServiceConnection) {
        try {
            SAMManager samManager = null;
            samManager = new SAMManager(context, emdkServiceConnection);
            return samManager;
        }
        catch (Throwable t) {
            Log.e((String)TAG, (String)("#EMDK-API# SAMManagerHelper::Caught exception : " + t.getMessage()));
            return null;
        }
    }

    public static void release(SAMManager samManager) {
        samManager.release();
    }

    static SAMResults mapCode(int res) {
        SAMResults results = samResultsLookUp.get(res);
        if (results == null) {
            return SAMResults.UNDEFINED;
        }
        return results;
    }

    static {
        try {
            SAMResults[] vals = SAMResults.values();
            samResultsLookUp = new HashMap<Integer, SAMResults>(vals.length);
            for (SAMResults scnRes : vals) {
                samResultsLookUp.put(scnRes.getVal(), scnRes);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("" + e.getMessage()));
        }
    }
}

