/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.scanandpair;

public class ScanAndPairConfig {
    public Boolean alwaysScan = true;
    public BluetoothInfo bluetoothInfo = new BluetoothInfo();
    public NotificationType notificationType = NotificationType.BEEPER;
    public ScanInfo scanInfo = new ScanInfo();

    ScanAndPairConfig() {
    }

    public void resetToDefaults() {
        this.alwaysScan = true;
        this.notificationType = NotificationType.BEEPER;
        if (this.bluetoothInfo != null) {
            this.bluetoothInfo.deviceName = "";
            this.bluetoothInfo.macAddress = "";
            this.bluetoothInfo.pairingPin = "";
        } else {
            this.bluetoothInfo = new BluetoothInfo();
        }
        if (this.scanInfo != null) {
            this.scanInfo.scannedData = "";
            this.scanInfo.scanDataType = ScanDataType.UNSPECIFIED;
            this.scanInfo.deviceIdentifier = DeviceIdentifier.DEFAULT;
            this.scanInfo.scanTimeout = 10000;
            this.scanInfo.triggerType = TriggerType.HARD;
        } else {
            this.scanInfo = new ScanInfo();
        }
    }

    public static class BluetoothInfo {
        public String deviceName = "";
        public String macAddress = "";
        public String pairingPin = "";
    }

    public static enum NotificationType {
        BEEPER,
        NONE;

    }

    public static class ScanInfo {
        private String scannedData = "";
        public ScanDataType scanDataType = ScanDataType.UNSPECIFIED;
        public DeviceIdentifier deviceIdentifier = DeviceIdentifier.DEFAULT;
        public int scanTimeout = 10000;
        public TriggerType triggerType = TriggerType.HARD;

        public String getScannedData() {
            return this.scannedData;
        }

        void setScannedData(String data) {
            this.scannedData = data;
        }
    }

    public static enum ScanDataType {
        MAC_ADDRESS,
        DEVICE_NAME,
        UNSPECIFIED;

    }

    public static enum DeviceIdentifier {
        INTERNAL_CAMERA1,
        INTERNAL_IMAGER1,
        INTERNAL_LASER1,
        BLUETOOTH_IMAGER1,
        DEFAULT;

    }

    public static enum TriggerType {
        SOFT,
        HARD;

    }
}

