/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.serialcomm;

import android.content.Context;
import android.util.Log;
import com.symbol.emdk.EMDKBase;
import com.symbol.emdk.EMDKManager;
import com.symbol.emdk.EMDKServiceConnection;
import com.symbol.emdk.emdkservice.SvcResult;
import com.symbol.emdk.emdkservice.serialcomm.SvcSerialCommConfig;
import com.symbol.emdk.emdkservice.serialcomm.SvcSerialCommResponse;
import com.symbol.emdk.emdkservice.serialcomm.SvcSerialPortInfo;
import com.symbol.emdk.serialcomm.SerialCommConfig;
import com.symbol.emdk.serialcomm.SerialCommException;
import com.symbol.emdk.serialcomm.SerialCommManager;
import com.symbol.emdk.serialcomm.SerialCommResults;
import com.symbol.emdk.serialcomm.SerialCommUtils;
import com.symbol.emdk.serialcomm.SerialPortInfo;

public class SerialComm
extends EMDKBase {
    private static final String TAG = "Serial_Comm";
    private Context context = null;
    private EMDKServiceConnection emdkServiceConnection = null;
    private boolean isReleased = false;
    private SerialCommManager serialCommManager = null;
    private SerialPortInfo serialPortInfo = null;
    public static final String DEFAULT_PORT_NAME = "Serial port 1";
    static final String DEFAULT_PORT_FRIENDLY_NAME = "Serial port 1";

    SerialComm(Context context, EMDKServiceConnection emdkServiceConnection, boolean isLegacy, SerialCommManager serialCommManager, SerialPortInfo serialPortInfo) throws SerialCommException {
        super(EMDKManager.FEATURE_TYPE.SERIALCOMM);
        this.context = context;
        this.emdkServiceConnection = emdkServiceConnection;
        if (isLegacy) {
            SerialCommResults result = SerialCommResults.FAILURE;
            if (emdkServiceConnection != null && emdkServiceConnection.isServiceConnected()) {
                try {
                    int ret = emdkServiceConnection.getService().sciIntialize(true);
                    result = SerialCommUtils.getResult(ret);
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("" + e.getMessage()));
                }
            } else {
                result = SerialCommResults.EMDK_NOT_OPENED;
            }
            if (result != SerialCommResults.SUCCESS) {
                throw new SerialCommException(result);
            }
            this.serialPortInfo = new SerialPortInfo("Serial port 1", "Serial port 1");
        } else {
            this.serialPortInfo = serialPortInfo;
            this.serialCommManager = serialCommManager;
        }
    }

    void markAsReleased() {
        this.isReleased = true;
    }

    void release() {
        if (this.emdkServiceConnection != null && this.emdkServiceConnection.isServiceConnected()) {
            try {
                this.isReleased = true;
                this.emdkServiceConnection.getService().sciUnIntialize(true);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
    }

    public boolean isEnabled() {
        if (this.emdkServiceConnection != null && this.emdkServiceConnection.isServiceConnected()) {
            try {
                return this.emdkServiceConnection.getService().sciIsEnabled(this.serialPortInfo.getPortName()) == 1;
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
        return false;
    }

    public void enable() throws SerialCommException {
        SerialCommResults result = SerialCommResults.EMDK_NOT_OPENED;
        if (this.isReleased) {
            result = SerialCommResults.INVALID_OBJECT;
        } else if (this.emdkServiceConnection != null && this.emdkServiceConnection.isServiceConnected()) {
            try {
                int ret = this.emdkServiceConnection.getService().sciEnable(this.serialPortInfo.getPortName());
                result = SerialCommUtils.getResult(ret);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
                result = SerialCommResults.FAILURE;
            }
        }
        if (result != SerialCommResults.SUCCESS) {
            throw new SerialCommException(result);
        }
    }

    public void disable() throws SerialCommException {
        SerialCommResults result = SerialCommResults.EMDK_NOT_OPENED;
        if (this.isReleased) {
            result = SerialCommResults.INVALID_OBJECT;
        } else if (this.emdkServiceConnection != null && this.emdkServiceConnection.isServiceConnected()) {
            try {
                int ret = this.emdkServiceConnection.getService().sciDisable(this.serialPortInfo.getPortName());
                result = SerialCommUtils.getResult(ret);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
                result = SerialCommResults.FAILURE;
            }
        }
        if (result != SerialCommResults.SUCCESS) {
            throw new SerialCommException(result);
        }
    }

    public int write(byte[] data, int bytesToWrite) throws SerialCommException {
        SerialCommResults result = SerialCommResults.EMDK_NOT_OPENED;
        int bytesWritten = 0;
        if (this.isReleased) {
            result = SerialCommResults.INVALID_OBJECT;
        } else if (this.emdkServiceConnection != null && this.emdkServiceConnection.isServiceConnected()) {
            try {
                SvcSerialCommResponse ret = this.emdkServiceConnection.getService().sciWrite(data, bytesToWrite, this.serialPortInfo.getPortName());
                bytesWritten = ret.bytesWritten;
                result = SerialCommUtils.getResult(ret.errorCode);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
                result = SerialCommResults.FAILURE;
            }
        }
        if (result != SerialCommResults.SUCCESS) {
            throw new SerialCommException(result);
        }
        return bytesWritten;
    }

    public byte[] read(int readTimeOut) throws SerialCommException {
        byte[] readBuffer = null;
        SerialCommResults result = SerialCommResults.EMDK_NOT_OPENED;
        if (this.isReleased) {
            result = SerialCommResults.INVALID_OBJECT;
        } else if (this.emdkServiceConnection != null && this.emdkServiceConnection.isServiceConnected()) {
            try {
                SvcSerialCommResponse ret = this.emdkServiceConnection.getService().sciRead(readTimeOut, this.serialPortInfo.getPortName());
                readBuffer = ret.readBuffer;
                result = SerialCommUtils.getResult(ret.errorCode);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
                result = SerialCommResults.FAILURE;
            }
        }
        if (result != SerialCommResults.SUCCESS) {
            throw new SerialCommException(result);
        }
        return readBuffer;
    }

    public SerialCommConfig getConfig() throws SerialCommException {
        SerialCommConfig config = null;
        SerialCommResults result = SerialCommResults.EMDK_NOT_OPENED;
        String errorMsg = "";
        int errorCode = 0;
        if (this.isReleased) {
            result = SerialCommResults.INVALID_OBJECT;
        } else if (this.emdkServiceConnection != null && this.emdkServiceConnection.isServiceConnected()) {
            try {
                SvcSerialCommConfig svcConfig = this.emdkServiceConnection.getService().sciGetConfig(this.serialPortInfo.getPortName());
                result = SerialCommUtils.getResult(svcConfig.errorCode);
                if (result == SerialCommResults.SUCCESS) {
                    config = new SerialCommConfig(svcConfig);
                } else {
                    errorMsg = svcConfig.errorMessage;
                    errorCode = svcConfig.errorCode;
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
                result = SerialCommResults.FAILURE;
                errorMsg = "" + e.getMessage();
            }
        }
        if (result != SerialCommResults.SUCCESS) {
            throw new SerialCommException(result, errorCode, errorMsg);
        }
        return config;
    }

    public void setConfig(SerialCommConfig config) throws SerialCommException {
        SerialCommResults result = SerialCommResults.EMDK_NOT_OPENED;
        String errorMsg = "";
        int errorCode = 0;
        if (this.isReleased) {
            result = SerialCommResults.INVALID_OBJECT;
        } else if (this.emdkServiceConnection != null && this.emdkServiceConnection.isServiceConnected()) {
            try {
                SvcSerialCommConfig svcConfig = new SvcSerialCommConfig();
                svcConfig.baudRate = config.baudRate;
                svcConfig.stopBit = config.stopBit.getValue();
                svcConfig.dataBit = config.dataBit.getValue();
                svcConfig.parity = config.parity.getValue();
                svcConfig.flowControlMode = config.flowControlMode.getValue();
                SvcResult ret = this.emdkServiceConnection.getService().sciSetConfig(svcConfig, this.serialPortInfo.getPortName());
                result = SerialCommUtils.getResult(ret.errorCode);
                errorMsg = ret.errorDescription;
                errorCode = ret.errorCode;
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
                errorMsg = "" + e.getMessage();
                result = SerialCommResults.FAILURE;
            }
        }
        if (result != SerialCommResults.SUCCESS) {
            throw new SerialCommException(result, errorCode, errorMsg);
        }
    }

    public boolean getSignalState(ControlSignal signal) throws SerialCommException {
        SerialCommResults result = SerialCommResults.EMDK_NOT_OPENED;
        String errorMsg = "";
        int errorCode = 0;
        boolean signalState = false;
        if (this.isReleased) {
            result = SerialCommResults.INVALID_OBJECT;
        } else if (this.emdkServiceConnection != null && this.emdkServiceConnection.isServiceConnected()) {
            try {
                SvcResult ret = this.emdkServiceConnection.getService().sciGetControlSignalState(signal.getValue(), this.serialPortInfo.getPortName());
                result = SerialCommUtils.getResult(ret.errorCode);
                if (result == SerialCommResults.SUCCESS) {
                    signalState = ret.data != 0;
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
                result = SerialCommResults.FAILURE;
                errorMsg = "" + e.getMessage();
            }
        }
        if (result != SerialCommResults.SUCCESS) {
            throw new SerialCommException(result, errorCode, errorMsg);
        }
        return signalState;
    }

    public void setSignalState(ControlSignal controlSignal, boolean signalStatus) throws SerialCommException {
        SerialCommResults result = SerialCommResults.EMDK_NOT_OPENED;
        String errorMsg = "";
        int errorCode = 0;
        if (this.isReleased) {
            result = SerialCommResults.INVALID_OBJECT;
        } else if (this.emdkServiceConnection != null && this.emdkServiceConnection.isServiceConnected()) {
            try {
                SvcResult ret = this.emdkServiceConnection.getService().sciSetControlSignalState(controlSignal.getValue(), signalStatus, this.serialPortInfo.getPortName());
                result = SerialCommUtils.getResult(ret.errorCode);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
                result = SerialCommResults.FAILURE;
                errorMsg = "" + e.getMessage();
            }
        }
        if (result != SerialCommResults.SUCCESS) {
            throw new SerialCommException(result, errorCode, errorMsg);
        }
    }

    public SerialPortInfo getPortInfo() {
        SerialPortInfo serialPortInfo = new SerialPortInfo("", "");
        if (this.emdkServiceConnection != null && this.emdkServiceConnection.isServiceConnected()) {
            try {
                SvcSerialPortInfo svcPortInfo = this.emdkServiceConnection.getService().scigetPortInfo(this.serialPortInfo.getPortName());
                serialPortInfo = new SerialPortInfo(svcPortInfo.portName, svcPortInfo.friendlyName);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
        return serialPortInfo;
    }

    public static enum ControlSignal {
        DTR(0),
        DCD(1),
        DSR(2),
        RI(3),
        RTS(4),
        CTS(5);

        int id = 0;

        private ControlSignal(int id) {
            this.id = id;
        }

        int getValue() {
            return this.id;
        }
    }
}

