/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.serialcomm;

import android.content.Context;
import android.util.Log;
import com.symbol.emdk.EMDKBase;
import com.symbol.emdk.EMDKManager;
import com.symbol.emdk.EMDKServiceConnection;
import com.symbol.emdk.emdkservice.serialcomm.SvcSerialPortInfo;
import com.symbol.emdk.serialcomm.SerialComm;
import com.symbol.emdk.serialcomm.SerialCommException;
import com.symbol.emdk.serialcomm.SerialCommResults;
import com.symbol.emdk.serialcomm.SerialCommUtils;
import com.symbol.emdk.serialcomm.SerialPortInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SerialCommManager
extends EMDKBase {
    private static final String TAG = "Serial_Comm_Manager";
    private Context context = null;
    private EMDKServiceConnection emdkServiceConnection = null;
    private boolean isReleased = false;
    ArrayList<SerialPortInfo> supportedPorts = new ArrayList();
    static List<SerialComm> createdSerialComms = new CopyOnWriteArrayList<SerialComm>();

    SerialCommManager(Context context, EMDKServiceConnection emdkServiceConnection) throws SerialCommException {
        super(EMDKManager.FEATURE_TYPE.SERIALCOMM_EX);
        this.context = context;
        this.emdkServiceConnection = emdkServiceConnection;
        SerialCommResults result = SerialCommResults.FAILURE;
        if (emdkServiceConnection != null && emdkServiceConnection.isServiceConnected()) {
            try {
                int ret = emdkServiceConnection.getService().sciIntialize(false);
                result = SerialCommUtils.getResult(ret);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        } else {
            result = SerialCommResults.EMDK_NOT_OPENED;
        }
        if (result != SerialCommResults.SUCCESS) {
            throw new SerialCommException(result);
        }
    }

    void release() {
        if (this.emdkServiceConnection != null && this.emdkServiceConnection.isServiceConnected()) {
            try {
                this.isReleased = true;
                this.emdkServiceConnection.getService().sciUnIntialize(false);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
        if (createdSerialComms != null) {
            for (SerialComm serialComm : createdSerialComms) {
                serialComm.markAsReleased();
            }
            createdSerialComms.clear();
        }
    }

    public List<SerialPortInfo> getSupportedPorts() throws SerialCommException {
        SerialCommResults result = SerialCommResults.EMDK_NOT_OPENED;
        if (this.isReleased) {
            result = SerialCommResults.INVALID_OBJECT;
        } else if (this.emdkServiceConnection != null && this.emdkServiceConnection.isServiceConnected()) {
            try {
                this.supportedPorts.clear();
                List<SvcSerialPortInfo> listSvcSerialPorts = this.emdkServiceConnection.getService().sciGetSupportedPorts();
                if (null != listSvcSerialPorts) {
                    result = SerialCommResults.SUCCESS;
                    for (SvcSerialPortInfo portInfo : listSvcSerialPorts) {
                        this.supportedPorts.add(new SerialPortInfo(portInfo.portName, portInfo.friendlyName));
                    }
                } else {
                    result = SerialCommResults.FAILURE;
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
                result = SerialCommResults.FAILURE;
            }
        }
        if (result != SerialCommResults.SUCCESS) {
            throw new SerialCommException(result);
        }
        return this.supportedPorts;
    }

    public SerialComm getPort(SerialPortInfo serialPortInfo) throws SerialCommException {
        SerialCommResults result = SerialCommResults.FAILURE;
        for (SerialComm serialComm : createdSerialComms) {
            if (!serialComm.getPortInfo().getPortName().equalsIgnoreCase(serialPortInfo.getPortName())) continue;
            return serialComm;
        }
        if (this.emdkServiceConnection != null && this.emdkServiceConnection.isServiceConnected()) {
            try {
                SvcSerialPortInfo svcSerialPortInfo = new SvcSerialPortInfo(serialPortInfo.friendlyName, serialPortInfo.portName);
                int ret = this.emdkServiceConnection.getService().sciGetPort(svcSerialPortInfo);
                result = SerialCommUtils.getResult(ret);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        } else {
            result = SerialCommResults.EMDK_NOT_OPENED;
        }
        SerialComm serialComm = null;
        if (result != SerialCommResults.SUCCESS) {
            throw new SerialCommException(result);
        }
        try {
            serialComm = new SerialComm(this.context, this.emdkServiceConnection, false, this, serialPortInfo);
            createdSerialComms.add(serialComm);
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("" + ex.getMessage()));
            result = SerialCommResults.FAILURE;
            throw new SerialCommException(result);
        }
        return serialComm;
    }
}

