/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.simulscan;

import android.os.RemoteException;
import android.util.Log;
import com.symbol.emdk.EMDKServiceConnection;
import com.symbol.emdk.emdkservice.simulscan.ISvcSimulScanProcessedDataCallback;
import com.symbol.emdk.emdkservice.simulscan.SvcSimulScanData;
import com.symbol.emdk.emdkservice.simulscan.SvcSimulScanElement;
import com.symbol.emdk.emdkservice.simulscan.SvcSimulScanGroup;
import com.symbol.emdk.emdkservice.simulscan.SvcSimulScanParcelData;
import com.symbol.emdk.emdkservice.simulscan.SvcSimulScanRegion;
import com.symbol.emdk.emdkservice.simulscan.SvcSimulScanTemplate;
import com.symbol.emdk.emdkservice.simulscan.SvcSimulScanTemplateElement;
import com.symbol.emdk.emdkservice.simulscan.SvcSimulScanTemplateGroup;
import com.symbol.emdk.emdkservice.simulscan.SvcSimulScanTemplateRegion;
import com.symbol.emdk.simulscan.RegionType;
import com.symbol.emdk.simulscan.SimulScanData;
import com.symbol.emdk.simulscan.SimulScanGroup;
import com.symbol.emdk.simulscan.SimulScanReader;
import com.symbol.emdk.simulscan.SimulScanRegion;
import com.symbol.emdk.simulscan.SimulScanTemplateGroup;
import com.symbol.emdk.simulscan.SimulScanTemplateRegion;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;

class SimulScanOnDataCallbackInternal
extends ISvcSimulScanProcessedDataCallback.Stub {
    private static final String TAG = "SimulScan_OnData_Callback_Internal";
    SimulScanReader ssdcReader = null;
    private EMDKServiceConnection emdkServiceConnection;

    public SimulScanOnDataCallbackInternal(SimulScanReader ssdcReader, EMDKServiceConnection emdkServiceConnection) {
        this.ssdcReader = ssdcReader;
        this.emdkServiceConnection = emdkServiceConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSSDCData(SvcSimulScanParcelData data) throws RemoteException {
        if (this.ssdcReader.dataListenerCallbacks == null) {
            return;
        }
        if (data.pfd != null) {
            FileInputStream is = null;
            ObjectInputStream ois = null;
            SimulScanData fData = null;
            try {
                Log.e((String)"AAA", (String)"SSDCRW data.pfd != null");
                is = new FileInputStream(data.pfd.getFileDescriptor());
                ois = new EMDKServiceObjectReader(is);
                Object obj = ois.readObject();
                Log.d((String)"AAA", (String)("SSDCRW obj type:" + obj.getClass().getName()));
                fData = (SimulScanData)obj;
                Log.d((String)"AAA", (String)"SSDCRW obj parsed to SimulScanData");
            }
            catch (RuntimeException e) {
                Log.e((String)TAG, (String)("SSDCRW Caught RuntimeException : " + e.getMessage()));
            }
            catch (ClassNotFoundException e) {
                Log.e((String)TAG, (String)("SSDCRW Caught ClassNotFounException : " + e.getMessage()));
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("SSDCRW Caught IOException : " + e.getMessage()));
            }
            catch (Exception e) {
                if (e.getMessage() != null) {
                    Log.e((String)TAG, (String)("SSDCRW Caught exception : " + e.getMessage()));
                } else {
                    Log.e((String)TAG, (String)"SSDCRW Caught exception");
                }
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException e) {
                        Log.e((String)TAG, (String)("" + e.getMessage()));
                    }
                    ois = null;
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        Log.e((String)TAG, (String)("" + e.getMessage()));
                    }
                    is = null;
                }
                System.gc();
            }
            if (fData != null) {
                new DataCallbackThread(this.ssdcReader, fData).start();
            }
        } else if (data.aidlData != null) {
            new AIDLDataCallbackThread(this.ssdcReader, data.aidlData).start();
        }
    }

    class EMDKServiceObjectReader
    extends ObjectInputStream {
        public EMDKServiceObjectReader(InputStream input) throws StreamCorruptedException, IOException {
            super(input);
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            ObjectStreamClass read = super.readClassDescriptor();
            if (read.getName().startsWith("com.symbol.emdk.emdkservice.simulscan.")) {
                return ObjectStreamClass.lookup(Class.forName(read.getName().replace("com.symbol.emdk.emdkservice.simulscan.", "com.symbol.emdk.simulscan.")));
            }
            return read;
        }
    }

    class DataCallbackThread
    extends Thread {
        SimulScanReader ssdcReader;
        SimulScanData data;

        DataCallbackThread(SimulScanReader ssdcReader, SimulScanData data) {
            if (ssdcReader == null || data == null) {
                return;
            }
            this.ssdcReader = ssdcReader;
            this.data = data;
        }

        @Override
        public void run() {
            try {
                if (this.ssdcReader.dataListenerCallbacks != null) {
                    for (SimulScanReader.DataListerner dataListenerCallback : this.ssdcReader.dataListenerCallbacks) {
                        dataListenerCallback.onData(this.data);
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)SimulScanOnDataCallbackInternal.TAG, (String)("" + e.getMessage()));
            }
        }
    }

    class AIDLDataCallbackThread
    extends Thread {
        SimulScanReader ssdcReader;
        SvcSimulScanData formData;

        AIDLDataCallbackThread(SimulScanReader ssdcReader, SvcSimulScanData formData) {
            if (ssdcReader == null || formData == null) {
                return;
            }
            this.ssdcReader = ssdcReader;
            this.formData = formData;
        }

        @Override
        public void run() {
            if (this.ssdcReader.dataListenerCallbacks == null) {
                return;
            }
            SimulScanData fData = new SimulScanData();
            fData.timeStamp = this.formData.getTimestamp();
            SvcSimulScanTemplate svcTemplate = this.formData.getTemplate();
            fData.template.name = svcTemplate.getName();
            fData.template.number = svcTemplate.getId();
            fData.template.height = svcTemplate.getHeight();
            fData.template.width = svcTemplate.getWidth();
            for (SvcSimulScanTemplateElement svcTempElement : svcTemplate.getElements()) {
                if (svcTempElement instanceof SvcSimulScanTemplateRegion) {
                    SimulScanTemplateRegion tempRegion = new SimulScanTemplateRegion(svcTempElement.getRegionNumber(), svcTempElement.getName());
                    SvcSimulScanTemplateRegion svcTempRegion = (SvcSimulScanTemplateRegion)svcTempElement;
                    tempRegion.height = svcTempRegion.getHeight();
                    tempRegion.width = svcTempRegion.getWidth();
                    tempRegion.x = svcTempRegion.getX();
                    tempRegion.y = svcTempRegion.getY();
                    tempRegion.regionType = RegionType.values()[svcTempRegion.getRegionType().ordinal()];
                    fData.template.elements.add(tempRegion);
                    continue;
                }
                if (!(svcTempElement instanceof SvcSimulScanTemplateGroup)) continue;
                SimulScanTemplateGroup tempGroup = new SimulScanTemplateGroup(svcTempElement.getRegionNumber(), svcTempElement.getName());
                for (SvcSimulScanTemplateRegion svcTempRegion : ((SvcSimulScanTemplateGroup)svcTempElement).getGroupRegions()) {
                    SimulScanTemplateRegion tempRegion = new SimulScanTemplateRegion(svcTempRegion.getRegionNumber(), svcTempRegion.getName());
                    tempRegion.height = svcTempRegion.getHeight();
                    tempRegion.width = svcTempRegion.getWidth();
                    tempRegion.x = svcTempRegion.getX();
                    tempRegion.y = svcTempRegion.getY();
                    tempRegion.regionType = RegionType.values()[svcTempRegion.getRegionType().ordinal()];
                    tempGroup.regions.add(tempRegion);
                }
                fData.template.elements.add(tempGroup);
            }
            for (SvcSimulScanElement svcElement : this.formData.getElements()) {
                if (svcElement instanceof SvcSimulScanRegion) {
                    SimulScanRegion region = new SimulScanRegion();
                    region.name = svcElement.getName();
                    region.number = svcElement.getElementNumber();
                    region.processingMode = RegionType.values()[((SvcSimulScanRegion)svcElement).getRegionType().ordinal()];
                    region.data = svcElement.getData();
                    region.image = ((SvcSimulScanRegion)svcElement).getImage();
                    region.absConfidence = ((SvcSimulScanRegion)svcElement).getAbsoluteConfidence();
                    region.relConfidence = ((SvcSimulScanRegion)svcElement).getRelativeConfidence();
                    fData.processedElements.add(region);
                    continue;
                }
                if (!(svcElement instanceof SvcSimulScanGroup)) continue;
                SimulScanGroup group = new SimulScanGroup();
                group.name = svcElement.getName();
                group.number = svcElement.getElementNumber();
                SvcSimulScanGroup svcGroup = (SvcSimulScanGroup)svcElement;
                for (SvcSimulScanRegion svcRegion : svcGroup.getGroupRegions()) {
                    SimulScanRegion region = new SimulScanRegion();
                    region.name = svcRegion.getName();
                    region.number = svcRegion.getElementNumber();
                    region.processingMode = RegionType.values()[svcRegion.getRegionType().ordinal()];
                    region.data = svcRegion.getData();
                    region.image = svcRegion.getImage();
                    region.absConfidence = svcRegion.getAbsoluteConfidence();
                    region.relConfidence = svcRegion.getRelativeConfidence();
                    group.addProcessedRegion(region);
                }
                fData.processedElements.add(group);
            }
            try {
                if (this.ssdcReader.dataListenerCallbacks != null) {
                    for (SimulScanReader.DataListerner dataListenerCallback : this.ssdcReader.dataListenerCallbacks) {
                        dataListenerCallback.onData(fData);
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)SimulScanOnDataCallbackInternal.TAG, (String)("" + e.getMessage()));
            }
        }
    }
}

