/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.simulscan;

import android.util.Log;
import android.util.SparseArray;

@Deprecated
public enum SimulScanResults {
    SUCCESS(0),
    ALREADY_SCANNING(2),
    ALREADY_STOPPED_SCANNING(6),
    READER_ALREADY_ENABLED(8),
    READER_IN_USE(9),
    READER_ALREADY_DISABLED(10),
    FEATURE_NOT_SUPPORTED(24),
    READER_NOT_ENABLED(26),
    INVALID_OBJECT(36),
    FAILED_TO_LOAD_TEMPLATE(38),
    FAILED_TO_SET_TEMPLATE(40),
    TEMPLATE_NOT_SET(41),
    INVALID_VALUE(42),
    NO_DATA_LISTENER(43),
    EMDK_NOT_OPENED(44),
    READER_INIT_FAILED(45),
    READER_DEINIT_FAILED(46),
    FETCH_TEMPLATE_NOT_ALLOWED(47),
    FETCH_TEMPLATE_IN_PROGRESS(48),
    UNDEFINED(254),
    FAILURE(255);

    private int id;
    private String discription;
    private static SparseArray<SimulScanResults> resultsLookUp;

    private SimulScanResults(int id) {
        this.id = id;
    }

    public int getValue() {
        return this.id;
    }

    void setValue(int id, String discription) {
        this.id = id;
        this.discription = discription;
    }

    static SimulScanResults getSimulScanResult(int errCode) {
        SimulScanResults results = (SimulScanResults)((Object)resultsLookUp.get(errCode));
        if (results == null) {
            return UNDEFINED;
        }
        return results;
    }

    public String getDescription() {
        if (this.discription == null || this.discription.compareTo("") == 0) {
            return SimulScanResults.getErrorDescription(this);
        }
        return this.discription;
    }

    static String getErrorDescription(SimulScanResults errorCode) {
        String errDescription = "";
        switch (errorCode) {
            case SUCCESS: {
                errDescription = "Success";
                break;
            }
            case ALREADY_SCANNING: {
                errDescription = "A scan operation is already in progress. Requested operation failed!";
                break;
            }
            case ALREADY_STOPPED_SCANNING: {
                errDescription = "The selected reader has already stopped scanning";
                break;
            }
            case READER_ALREADY_ENABLED: {
                errDescription = "Selected reader is already enabled";
                break;
            }
            case READER_IN_USE: {
                errDescription = "Another reader is already enabled and in use. Only one reader can be enabled at a time!";
                break;
            }
            case READER_ALREADY_DISABLED: {
                errDescription = "The reader is already disabled";
                break;
            }
            case FEATURE_NOT_SUPPORTED: {
                errDescription = "The feature is not supported completely or for specified input.";
                break;
            }
            case READER_NOT_ENABLED: {
                errDescription = "Selected reader is not enabled. The requested operation requires the device to be enabled!";
                break;
            }
            case INVALID_OBJECT: {
                errDescription = "The Selected reader object has been released and is no longer valid!";
                break;
            }
            case FAILED_TO_LOAD_TEMPLATE: {
                errDescription = "Failed to load template";
                break;
            }
            case FAILED_TO_SET_TEMPLATE: {
                errDescription = "Failed to set template";
                break;
            }
            case TEMPLATE_NOT_SET: {
                errDescription = "A valid template has not been set";
                break;
            }
            case INVALID_VALUE: {
                errDescription = "The value passed is not valid.";
                break;
            }
            case NO_DATA_LISTENER: {
                errDescription = "Data listner must be set before read() is called";
                break;
            }
            case EMDK_NOT_OPENED: {
                errDescription = "EMDK is not opened";
                break;
            }
            case FAILURE: {
                errDescription = "Failure";
                break;
            }
            case READER_INIT_FAILED: {
                errDescription = "Reader initialization failed";
                break;
            }
            case READER_DEINIT_FAILED: {
                errDescription = "Reader un-initialization failed";
                break;
            }
            case FETCH_TEMPLATE_NOT_ALLOWED: {
                errDescription = "Fetch template not allowed while a read is in progress";
                break;
            }
            case FETCH_TEMPLATE_IN_PROGRESS: {
                errDescription = "Fetching templates are already in progress. Requested operation failed!";
                break;
            }
            default: {
                errDescription = "Error code not be defined.";
            }
        }
        return errDescription;
    }

    static {
        try {
            SimulScanResults[] vals = SimulScanResults.values();
            resultsLookUp = new SparseArray(vals.length);
            for (SimulScanResults ssdcRes : vals) {
                resultsLookUp.put(ssdcRes.getValue(), (Object)ssdcRes);
            }
        }
        catch (Exception e) {
            Log.e((String)SimulScanResults.class.getCanonicalName(), (String)"Failed to initialized resultsLookUp");
        }
    }
}

