/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.simulscansample1;

import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.symbol.emdk.EMDKManager;
import com.symbol.emdk.EMDKResults;
import com.symbol.emdk.simulscan.SimulScanConfig;
import com.symbol.emdk.simulscan.SimulScanData;
import com.symbol.emdk.simulscan.SimulScanException;
import com.symbol.emdk.simulscan.SimulScanManager;
import com.symbol.emdk.simulscan.SimulScanMultiTemplate;
import com.symbol.emdk.simulscan.SimulScanReader;
import com.symbol.emdk.simulscan.SimulScanReaderInfo;
import com.symbol.emdk.simulscan.SimulScanStatusData;
import com.symbol.emdk.simulscansample1.MainActivity;
import com.symbol.emdk.simulscansample1.ResultsActivity;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DeviceControl
extends Fragment
implements AdapterView.OnItemSelectedListener,
EMDKManager.EMDKListener,
SimulScanReader.DataListerner,
SimulScanReader.StatusListerner,
View.OnClickListener {
    private static final String TAG = DeviceControl.class.getCanonicalName();
    private TextView textViewStatus = null;
    private Spinner spinner2 = null;
    private Button readBtn = null;
    private Button stopReadBtn = null;
    private EMDKManager emdkManager = null;
    private SimulScanManager simulscanManager = null;
    List<SimulScanReaderInfo> readerInfoList = null;
    EMDKResults results;
    SimulScanReader selectedSimulScanReader = null;
    static List<SimulScanData> simulscanDataList = Collections.synchronizedList(new ArrayList());
    Exception lastException;
    private int readerIndex = 0;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.d((String)TAG, (String)"SSC onCreate");
        this.results = EMDKManager.getEMDKManager((Context)this.getActivity().getApplicationContext(), (EMDKManager.EMDKListener)this);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        Log.d((String)TAG, (String)"SSC onCreateView");
        View rootView = inflater.inflate(2131361818, container, false);
        this.textViewStatus = (TextView)rootView.findViewById(2131230818);
        this.textViewStatus.setText((CharSequence)"Status:  Starting..");
        this.spinner2 = (Spinner)rootView.findViewById(2131230807);
        this.spinner2.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)this);
        this.readBtn = (Button)rootView.findViewById(2131230740);
        this.readBtn.setOnClickListener((View.OnClickListener)this);
        this.stopReadBtn = (Button)rootView.findViewById(2131230741);
        this.stopReadBtn.setOnClickListener((View.OnClickListener)this);
        if (this.results.statusCode != EMDKResults.STATUS_CODE.SUCCESS) {
            Log.e((String)TAG, (String)"EMDKManager object request failed!");
            this.textViewStatus.setText((CharSequence)"Status: EMDKManager object request failed!");
        }
        return rootView;
    }

    public void onStart() {
        super.onStart();
        Log.d((String)TAG, (String)"SSC onStart");
        if (this.selectedSimulScanReader != null) {
            try {
                if (!this.selectedSimulScanReader.isEnabled()) {
                    this.selectedSimulScanReader.enable();
                }
            }
            catch (SimulScanException e) {
                Log.e((String)TAG, (String)("Error enabling reader: " + e.getMessage()));
                e.printStackTrace();
                this.textViewStatus.setText((CharSequence)"Status: Error enabling reader");
            }
        }
    }

    public void onResume() {
        Log.d((String)TAG, (String)"SSC onResume");
        super.onResume();
        if (this.emdkManager != null) {
            this.simulscanManager = (SimulScanManager)this.emdkManager.getInstance(EMDKManager.FEATURE_TYPE.SIMULSCAN);
            try {
                if (this.simulscanManager != null) {
                    this.prepareScanner(this.spinner2.getSelectedItemPosition());
                } else {
                    Log.d((String)TAG, (String)"SSC onResume simulscanManager is null");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onPause() {
        Log.d((String)TAG, (String)"SSC onPause");
        super.onPause();
        try {
            this.deinitCurrentScanner();
        }
        catch (SimulScanException e) {
            e.printStackTrace();
        }
        if (this.simulscanManager != null) {
            this.simulscanManager = null;
        }
        if (this.emdkManager != null) {
            this.emdkManager.release(EMDKManager.FEATURE_TYPE.SIMULSCAN);
        }
    }

    public void onStop() {
        Log.d((String)TAG, (String)"SSC onStop");
        if (this.selectedSimulScanReader != null) {
            if (this.selectedSimulScanReader.isReadPending().booleanValue()) {
                try {
                    this.selectedSimulScanReader.cancelRead();
                }
                catch (SimulScanException e) {
                    Log.e((String)TAG, (String)("Error stopping reader: " + e.getMessage()));
                    e.printStackTrace();
                }
            }
            try {
                if (this.selectedSimulScanReader.isEnabled()) {
                    this.selectedSimulScanReader.disable();
                }
            }
            catch (SimulScanException e) {
                Log.e((String)TAG, (String)("Error disabling reader: " + e.getMessage()));
                e.printStackTrace();
            }
        }
        super.onStop();
    }

    public void onDestroy() {
        super.onDestroy();
        Log.d((String)TAG, (String)"SSC onDestroy");
        if (this.selectedSimulScanReader != null) {
            this.selectedSimulScanReader.removeDataListener((SimulScanReader.DataListerner)this);
            this.selectedSimulScanReader.removeStatusListener((SimulScanReader.StatusListerner)this);
        }
        if (this.simulscanManager != null) {
            this.emdkManager.release(EMDKManager.FEATURE_TYPE.SIMULSCAN);
            this.simulscanManager = null;
        }
        if (this.emdkManager != null) {
            this.emdkManager.release();
            this.emdkManager = null;
        }
    }

    private void addItemsOnSpinner(Spinner spinner, List<String> list) {
        ArrayAdapter dataAdapter = new ArrayAdapter((Context)this.getActivity(), 17367048, list);
        dataAdapter.setDropDownViewResource(0x1090009);
        spinner.setAdapter((SpinnerAdapter)dataAdapter);
    }

    public void deinitCurrentScanner() throws SimulScanException {
        if (this.selectedSimulScanReader != null) {
            if (this.selectedSimulScanReader.isReadPending().booleanValue()) {
                this.selectedSimulScanReader.cancelRead();
            }
            if (this.selectedSimulScanReader.isEnabled()) {
                this.selectedSimulScanReader.disable();
            }
            this.selectedSimulScanReader.removeDataListener((SimulScanReader.DataListerner)this);
            this.selectedSimulScanReader.removeStatusListener((SimulScanReader.StatusListerner)this);
            this.selectedSimulScanReader = null;
        }
    }

    public void initCurrentScanner() throws SimulScanException {
        this.selectedSimulScanReader.addStatusListener((SimulScanReader.StatusListerner)this);
        this.selectedSimulScanReader.addDataListener((SimulScanReader.DataListerner)this);
        this.selectedSimulScanReader.enable();
    }

    public void onItemSelected(AdapterView<?> parent, View view, int pos, long arg3) {
        if (parent.equals((Object)this.spinner2)) {
            this.prepareScanner(pos);
        }
    }

    public void prepareScanner(int pos) {
        SimulScanReaderInfo readerInfo;
        if (this.simulscanManager != null && (readerInfo = this.readerInfoList.get(pos)) != null) {
            Log.d((String)TAG, (String)("onItemSelected:" + readerInfo.getFriendlyName()));
            if (this.readerIndex != pos) {
                this.readerIndex = pos;
            }
            try {
                this.deinitCurrentScanner();
                this.selectedSimulScanReader = this.simulscanManager.getDevice(this.readerInfoList.get(this.readerIndex));
                this.initCurrentScanner();
            }
            catch (SimulScanException e) {
                Log.e((String)TAG, (String)("Error enabling reader: " + e.getMessage()));
                e.printStackTrace();
                this.textViewStatus.setText((CharSequence)"Status: Error enabling reader");
            }
        }
    }

    public void onNothingSelected(AdapterView<?> parent) {
        if (parent.equals((Object)this.spinner2)) {
            Log.d((String)TAG, (String)"onNothingSelected");
            try {
                this.deinitCurrentScanner();
            }
            catch (SimulScanException e) {
                Log.e((String)TAG, (String)("Error disabling reader: " + e.getMessage()));
                e.printStackTrace();
            }
        }
    }

    public void onOpened(EMDKManager emdkManager) {
        Log.d((String)TAG, (String)"onOpened");
        this.textViewStatus.setText((CharSequence)"Status: EMDK open success!");
        this.emdkManager = emdkManager;
        this.simulscanManager = (SimulScanManager)emdkManager.getInstance(EMDKManager.FEATURE_TYPE.SIMULSCAN);
        if (null == this.simulscanManager) {
            Log.e((String)TAG, (String)"Get SimulScanManager instance failed!");
            this.textViewStatus.setText((CharSequence)"Status: Get SimulScanManager instance failed!");
            Toast.makeText((Context)this.getActivity(), (CharSequence)"SimulScan feature is not supported", (int)0).show();
            this.getActivity().finish();
            return;
        }
        this.readerInfoList = this.simulscanManager.getSupportedDevicesInfo();
        ArrayList<String> nameList = new ArrayList<String>();
        for (SimulScanReaderInfo rinfo : this.readerInfoList) {
            nameList.add(rinfo.getFriendlyName());
        }
        this.addItemsOnSpinner(this.spinner2, nameList);
        this.spinner2.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)this);
        this.readerIndex = 0;
        try {
            this.selectedSimulScanReader = this.simulscanManager.getDevice(this.readerInfoList.get(this.readerIndex));
            this.initCurrentScanner();
        }
        catch (SimulScanException e) {
            e.printStackTrace();
        }
    }

    public void onClosed() {
        Log.d((String)TAG, (String)"onClosed: EMDK closed unexpectedly");
        this.emdkManager.release();
        this.emdkManager = null;
        this.textViewStatus.setText((CharSequence)"Status: EMDK closed unexpectedly!");
    }

    private void setCurrentConfig() throws Exception {
        SimulScanConfig config;
        if (this.selectedSimulScanReader != null && (config = this.selectedSimulScanReader.getConfig()) != null) {
            if (config.multiTemplate != null) {
                Log.d((String)TAG, (String)("Conf template name: " + config.multiTemplate.getTemplateName()));
            } else {
                Log.d((String)TAG, (String)"Conf template is null");
            }
            MainActivity parentActivity = (MainActivity)this.getActivity();
            if (parentActivity.localSettings.fileList == null || parentActivity.localSettings.fileList.size() == 0) {
                Log.e((String)TAG, (String)"Invalid template Path");
                throw new Exception();
            }
            Log.d((String)TAG, (String)("Template index: " + parentActivity.localSettings.selectedFileIndex));
            SimulScanMultiTemplate multiTemplate = new SimulScanMultiTemplate(this.simulscanManager, Uri.fromFile((File)parentActivity.localSettings.fileList.get(parentActivity.localSettings.selectedFileIndex)));
            if (multiTemplate != null) {
                config.multiTemplate = multiTemplate;
            }
            config.autoCapture = parentActivity.localSettings.enableAutoCapture;
            config.audioFeedback = parentActivity.localSettings.enableFeedbackAudio;
            config.hapticFeedback = parentActivity.localSettings.enableHaptic;
            config.ledFeedback = parentActivity.localSettings.enableLED;
            config.userConfirmationOnScan = parentActivity.localSettings.enableResultConfirmation;
            config.identificationTimeout = parentActivity.localSettings.identificationTimeout;
            config.processingTimeout = parentActivity.localSettings.processingTimeout;
            this.selectedSimulScanReader.setConfig(config);
        }
    }

    private void readCurrentScanner() throws Exception {
        this.setCurrentConfig();
        if (this.selectedSimulScanReader != null) {
            this.selectedSimulScanReader.read();
        }
    }

    private void stopReadCurrentScanner() throws SimulScanException {
        if (this.selectedSimulScanReader != null) {
            this.selectedSimulScanReader.cancelRead();
        }
    }

    public void onClick(View arg0) {
        if (arg0.equals(this.readBtn)) {
            Log.d((String)TAG, (String)"Read clicked");
            try {
                this.readCurrentScanner();
            }
            catch (Exception e) {
                this.lastException = e;
                this.textViewStatus.post(new Runnable(){

                    @Override
                    public void run() {
                        DeviceControl.this.textViewStatus.setText((CharSequence)("Status: " + DeviceControl.this.lastException.getMessage()));
                    }
                });
                Log.e((String)TAG, (String)("Exception while starting read: " + e.getMessage()));
                e.printStackTrace();
            }
        }
        if (arg0.equals(this.stopReadBtn)) {
            Log.d((String)TAG, (String)"Stop Read clicked");
            try {
                this.stopReadCurrentScanner();
            }
            catch (SimulScanException e) {
                this.lastException = e;
                this.textViewStatus.post(new Runnable(){

                    @Override
                    public void run() {
                        DeviceControl.this.textViewStatus.setText((CharSequence)("Status: " + DeviceControl.this.lastException.getMessage()));
                    }
                });
                Log.e((String)TAG, (String)("Exception while cancelling read : " + e.getMessage()));
                e.printStackTrace();
            }
        }
    }

    public void onStatus(SimulScanStatusData statusData) {
        if (statusData != null) {
            String statusText = "";
            switch (statusData.getState()) {
                case DISABLED: {
                    new AsyncStatusUpdate().execute(new String[]{"Status: " + statusData.getFriendlyName() + ": Closed reader successfully"});
                    break;
                }
                case ENABLED: {
                    new AsyncStatusUpdate().execute(new String[]{"Status: " + statusData.getFriendlyName() + ": Opened reader successfully"});
                    break;
                }
                case SCANNING: {
                    new AsyncStatusUpdate().execute(new String[]{"Status: " + statusData.getFriendlyName() + ": Started reader successfully"});
                    break;
                }
                case IDLE: {
                    statusText = "Status: " + statusData.getFriendlyName() + ": Stopped reader successfully";
                    switch (statusData.getExtendedState()) {
                        case PROCESSING_TIMEOUT: {
                            statusText = statusText + "\nReason: Processing timeout";
                            break;
                        }
                        case IDENTIFICATION_TIMEOUT: {
                            statusText = statusText + "\nReason: Identification timeout";
                            break;
                        }
                        case CANCELLED: {
                            statusText = statusText + "\nReason: Cancelled";
                            break;
                        }
                        case FORM_DECODED: {
                            statusText = statusText + "\nReason: Form decoded successfully";
                        }
                    }
                    new AsyncStatusUpdate().execute(new String[]{statusText});
                    break;
                }
                case ERROR: {
                    statusText = "Status: " + statusData.getFriendlyName() + " Error";
                    switch (statusData.getExtendedState()) {
                        case UNLICENSED_FEATURE: {
                            statusText = statusText + "\nUnlicensed Feature detected: " + statusData.getStatusDescription();
                            break;
                        }
                        default: {
                            statusText = statusText + "\n" + statusData.getStatusDescription();
                        }
                    }
                    new AsyncStatusUpdate().execute(new String[]{statusText});
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onData(SimulScanData simulScanData) {
        Log.v((String)TAG, (String)"onData");
        Intent intent = new Intent((Context)this.getActivity(), ResultsActivity.class);
        List<SimulScanData> list = simulscanDataList;
        synchronized (list) {
            simulscanDataList.add(simulScanData);
        }
        this.startActivity(intent);
    }

    private class AsyncStatusUpdate
    extends AsyncTask<String, Void, String> {
        private AsyncStatusUpdate() {
        }

        protected String doInBackground(String ... params) {
            return params[0];
        }

        protected void onPostExecute(String result) {
            DeviceControl.this.textViewStatus.setText((CharSequence)result);
        }
    }
}

