/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.simulscansample1;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.symbol.emdk.simulscan.RegionType;
import com.symbol.emdk.simulscan.SimulScanRegion;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class RegionArrayAdapter
extends ArrayAdapter<SimulScanRegion> {
    private List<SimulScanRegion> mRegions = null;

    public RegionArrayAdapter(Context context, int textViewResourceId, List<SimulScanRegion> regions) {
        super(context, textViewResourceId, regions);
        this.mRegions = regions;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        SimulScanRegion region;
        View v = convertView;
        CharSequence[] omrStatus = new CharSequence[]{"Checked", "Unchecked"};
        if (v == null) {
            LayoutInflater vi = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
            v = vi.inflate(2131361827, parent, false);
        }
        if (null != (region = this.mRegions.get(position))) {
            ImageView imgImage = (ImageView)v.findViewById(2131230783);
            TextView txtName = (TextView)v.findViewById(2131230785);
            TextView txtData = (TextView)v.findViewById(2131230782);
            TextView txtProcessingMode = (TextView)v.findViewById(2131230786);
            TextView txtAbsConf = (TextView)v.findViewById(2131230781);
            TextView txtRelConf = (TextView)v.findViewById(2131230787);
            if (null != imgImage && null != region.getImage()) {
                ByteArrayOutputStream baoStream = new ByteArrayOutputStream();
                region.getImage().compressToJpeg(new Rect(0, 0, region.getImage().getWidth(), region.getImage().getHeight()), 100, (OutputStream)baoStream);
                Bitmap bm = BitmapFactory.decodeStream((InputStream)new ByteArrayInputStream(baoStream.toByteArray()));
                imgImage.setImageBitmap(bm);
            } else if (region.getImage() == null) {
                imgImage.setImageResource(17170445);
            }
            if (null != txtName && null != region.getName()) {
                txtName.setText((CharSequence)region.getName().toString());
            }
            if (null != txtProcessingMode && null != region.getRegionType().name()) {
                txtProcessingMode.setText((CharSequence)region.getRegionType().name());
            }
            if (txtAbsConf != null) {
                String absConfText = "AC: ";
                absConfText = region.getAbsoluteConfidence() == -1 ? "" : absConfText + region.getAbsoluteConfidence();
                txtAbsConf.setText((CharSequence)absConfText);
            }
            if (txtRelConf != null) {
                String relConfText = "RC: ";
                relConfText = region.getRelativeConfidence() == -1 ? "" : relConfText + region.getRelativeConfidence();
                txtRelConf.setText((CharSequence)relConfText);
            }
            if (null != txtData) {
                String sText = "";
                if (region.getRegionType() == RegionType.OCR) {
                    String[] OCRResults;
                    if (region.getData() != null && null != (OCRResults = (String[])region.getData())) {
                        for (int nIndex = 0; nIndex < OCRResults.length; ++nIndex) {
                            if (nIndex != 0) {
                                sText = sText.concat("\n");
                            }
                            sText = sText.concat(OCRResults[nIndex]);
                        }
                    }
                    txtData.setText((CharSequence)sText);
                } else if (region.getRegionType() == RegionType.OMR) {
                    if (region.getData() != null) {
                        int iChecked = (Integer)region.getData();
                        switch (iChecked) {
                            case 1: {
                                sText = sText.concat(omrStatus[0].toString());
                                break;
                            }
                            case -1: {
                                sText = sText.concat(omrStatus[1].toString());
                                break;
                            }
                        }
                    } else {
                        sText = sText.concat(omrStatus[1].toString());
                    }
                    txtData.setText((CharSequence)sText);
                } else if (region.getRegionType() == RegionType.BARCODE) {
                    if (region.getData() != null) {
                        try {
                            sText = sText.concat((String)region.getData());
                        }
                        catch (ClassCastException e) {
                            sText = "Post-processing is off";
                        }
                    }
                    txtData.setText((CharSequence)sText);
                } else if (region.getRegionType() == RegionType.PICTURE) {
                    if (region.getData() != null) {
                        txtData.setText((CharSequence)"");
                    }
                } else {
                    txtData.setText((CharSequence)region.getData().toString());
                }
            }
            if (null != txtProcessingMode && null != region.getRegionType()) {
                txtProcessingMode.setText((CharSequence)region.getRegionType().name());
            }
        }
        return v;
    }
}

