/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.emdk.simulscansample1;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Environment;
import android.preference.CheckBoxPreference;
import android.preference.EditTextPreference;
import android.preference.ListPreference;
import android.preference.PreferenceFragment;
import android.util.Log;
import android.view.View;
import android.widget.Toast;
import com.symbol.emdk.simulscansample1.MainActivity;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class SettingsFragment
extends PreferenceFragment
implements SharedPreferences.OnSharedPreferenceChangeListener {
    private static final String TAG = SettingsFragment.class.getCanonicalName();
    private static final String NO_TEMPLATE_FOUND = "(No templates found)";
    private static final String SETTINGS_LAST_TEMPLATE_POS = "lastTemplatePos";

    public void onSharedPreferenceChanged(SharedPreferences prefs, String key) {
        MainActivity parentActivity = (MainActivity)this.getActivity();
        if (key.compareTo(this.getResources().getString(2131558421)) == 0) {
            ListPreference connectionPref = (ListPreference)this.findPreference(key);
            Log.d((String)TAG, (String)("Template PreferenceChanged: " + connectionPref.getValue()));
            parentActivity.localSettings.selectedFileIndex = Integer.valueOf(connectionPref.getValue());
            connectionPref.setSummary((CharSequence)connectionPref.getEntry().toString());
            SharedPreferences.Editor editor = prefs.edit();
            editor.putInt(SETTINGS_LAST_TEMPLATE_POS, parentActivity.localSettings.selectedFileIndex);
            editor.apply();
        } else if (key.compareTo("timeout_identification") == 0) {
            EditTextPreference connectionPref = (EditTextPreference)this.findPreference(key);
            Log.d((String)TAG, (String)("Identification PreferenceChanged: " + connectionPref.getText()));
            int idto = parentActivity.localSettings.identificationTimeout;
            try {
                idto = Integer.parseInt(connectionPref.getText());
            }
            catch (NumberFormatException ex) {
                Log.e((String)TAG, (String)("Invalid identification timeout exception: " + ex.getMessage()));
                Toast.makeText((Context)parentActivity.getApplicationContext(), (CharSequence)"Invalid identification timeout value", (int)1).show();
            }
            if (idto < 5000) {
                idto = 5000;
            }
            connectionPref.setText(String.valueOf(idto));
            parentActivity.localSettings.identificationTimeout = idto;
        } else if (key.compareTo("timeout_processing") == 0) {
            EditTextPreference connectionPref = (EditTextPreference)this.findPreference(key);
            Log.d((String)TAG, (String)("Processing PreferenceChanged: " + connectionPref.getText()));
            int processingTimeout = parentActivity.localSettings.processingTimeout;
            try {
                processingTimeout = Integer.parseInt(connectionPref.getText());
            }
            catch (NumberFormatException ex) {
                Log.e((String)TAG, (String)("Invalid processing timeout exception: " + ex.getMessage()));
                Toast.makeText((Context)parentActivity.getApplicationContext(), (CharSequence)"Invalid processing timeout value", (int)1).show();
            }
            connectionPref.setText(String.valueOf(processingTimeout));
            parentActivity.localSettings.processingTimeout = processingTimeout;
        } else if (key.compareTo("ui_result_confirmation") == 0) {
            CheckBoxPreference connectionPref = (CheckBoxPreference)this.findPreference(key);
            Log.d((String)TAG, (String)("result confrmation PreferenceChanged: " + connectionPref.isChecked()));
            parentActivity.localSettings.enableResultConfirmation = connectionPref.isChecked();
        } else if (key.compareTo("auto_capture") == 0) {
            CheckBoxPreference connectionPref = (CheckBoxPreference)this.findPreference(key);
            Log.d((String)TAG, (String)("Auto capture PreferenceChanged: " + connectionPref.isChecked()));
            parentActivity.localSettings.enableAutoCapture = connectionPref.isChecked();
        } else if (key.compareTo("feedback_audio") == 0) {
            CheckBoxPreference connectionPref = (CheckBoxPreference)this.findPreference(key);
            Log.d((String)TAG, (String)("Audio PreferenceChanged: " + connectionPref.isChecked()));
            parentActivity.localSettings.enableFeedbackAudio = connectionPref.isChecked();
        } else if (key.compareTo("feedback_haptic") == 0) {
            CheckBoxPreference connectionPref = (CheckBoxPreference)this.findPreference(key);
            Log.d((String)TAG, (String)("Haptic PreferenceChanged: " + connectionPref.isChecked()));
            parentActivity.localSettings.enableHaptic = connectionPref.isChecked();
        } else if (key.compareTo("feedback_led") == 0) {
            CheckBoxPreference connectionPref = (CheckBoxPreference)this.findPreference(key);
            Log.d((String)TAG, (String)("LED PreferenceChanged: " + connectionPref.isChecked()));
            parentActivity.localSettings.enableLED = connectionPref.isChecked();
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.addPreferencesFromResource(2131755008);
        ListPreference customListPref = (ListPreference)this.findPreference("pref_template");
        MainActivity parentActivity = (MainActivity)this.getActivity();
        this.RetrieveTemplates();
        if (customListPref != null) {
            ArrayList<String> entries = new ArrayList<String>();
            ArrayList<String> entryValues = new ArrayList<String>();
            String path = Environment.getExternalStorageDirectory().toString() + "/simulscan/templates";
            Log.d((String)TAG, (String)("Path: " + path));
            File f = new File(path);
            File[] file = f.listFiles();
            if (file != null) {
                for (int i = 0; i < file.length; ++i) {
                    Log.d((String)TAG, (String)("FileName:" + file[i].getName()));
                    entries.add(file[i].getName());
                    entryValues.add(Integer.valueOf(i).toString());
                }
            } else {
                Log.d((String)TAG, (String)"Cant find folder");
            }
            if (entries.isEmpty()) {
                entries.add(NO_TEMPLATE_FOUND);
                entryValues.add("");
            }
            customListPref.setEntries(entries.toArray(new CharSequence[entries.size()]));
            customListPref.setEntryValues(entryValues.toArray(new CharSequence[entryValues.size()]));
            SharedPreferences prefs = this.getPreferenceScreen().getSharedPreferences();
            int lastTemplatePos = prefs.getInt(SETTINGS_LAST_TEMPLATE_POS, 0);
            if (lastTemplatePos >= entries.size()) {
                lastTemplatePos = 0;
            }
            customListPref.setValueIndex(lastTemplatePos);
            customListPref.setSummary((CharSequence)entries.get(lastTemplatePos));
            if (((String)entryValues.get(lastTemplatePos)).compareTo("") != 0) {
                parentActivity.localSettings.fileList = new ArrayList<File>(Arrays.asList(file));
                parentActivity.localSettings.selectedFileIndex = lastTemplatePos;
            }
        }
        EditTextPreference pref1 = (EditTextPreference)this.findPreference("timeout_identification");
        parentActivity.localSettings.identificationTimeout = Integer.parseInt(pref1.getText());
        EditTextPreference pref2 = (EditTextPreference)this.findPreference("timeout_processing");
        parentActivity.localSettings.processingTimeout = Integer.parseInt(pref2.getText());
        CheckBoxPreference pref3 = (CheckBoxPreference)this.findPreference("ui_result_confirmation");
        parentActivity.localSettings.enableResultConfirmation = pref3.isChecked();
        CheckBoxPreference pref4 = (CheckBoxPreference)this.findPreference("auto_capture");
        parentActivity.localSettings.enableAutoCapture = pref4.isChecked();
        CheckBoxPreference pref6 = (CheckBoxPreference)this.findPreference("feedback_audio");
        parentActivity.localSettings.enableFeedbackAudio = pref6.isChecked();
        CheckBoxPreference pref7 = (CheckBoxPreference)this.findPreference("feedback_haptic");
        parentActivity.localSettings.enableHaptic = pref7.isChecked();
        CheckBoxPreference pref8 = (CheckBoxPreference)this.findPreference("feedback_led");
        parentActivity.localSettings.enableLED = pref8.isChecked();
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
    }

    public void onResume() {
        super.onResume();
        this.getPreferenceScreen().getSharedPreferences().registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }

    public void onPause() {
        super.onPause();
        this.getPreferenceScreen().getSharedPreferences().unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }

    public void RetrieveTemplates() {
        File source = new File("/enterprise/device/settings/datawedge/templates");
        File dest = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + "/simulscan/templates");
        try {
            SettingsFragment.copyTemplateDirectory(source, dest);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Exception while retrieving templates : " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public static void copyTemplateDirectory(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < sourceLocation.listFiles().length; ++i) {
                if (children[i].contains("templates.properties")) continue;
                SettingsFragment.copyTemplateDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
            }
        } else {
            int len;
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = new FileOutputStream(targetLocation);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }
}

