/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.scanandpairsample1;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import com.symbol.emdk.EMDKManager;
import com.symbol.emdk.EMDKResults;
import com.symbol.emdk.scanandpair.ScanAndPairConfig;
import com.symbol.emdk.scanandpair.ScanAndPairManager;
import com.symbol.emdk.scanandpair.ScanAndPairResults;
import com.symbol.emdk.scanandpair.StatusData;
import java.util.ArrayList;

public class MainActivity
extends Activity
implements EMDKManager.EMDKListener,
ScanAndPairManager.StatusListener {
    private EditText btName = null;
    private EditText btAddress = null;
    private CheckBox checkboxHardTrigger = null;
    private CheckBox checkBoxAlwaysScan = null;
    private Button scanAndPairButton = null;
    private Button scanAndUnpairButton = null;
    private Spinner scandataType = null;
    private TextView statusView = null;
    private EMDKManager emdkManager = null;
    ScanAndPairManager scanAndPairMgr = null;
    ScanAndPairManager.StatusListener statusCallbackObj = this;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2130903040);
        this.btName = (EditText)this.findViewById(2130837509);
        this.btAddress = (EditText)this.findViewById(2130837505);
        this.checkBoxAlwaysScan = (CheckBox)this.findViewById(2130837507);
        this.checkboxHardTrigger = (CheckBox)this.findViewById(2130837516);
        this.scanAndPairButton = (Button)this.findViewById(2130837513);
        this.scanAndUnpairButton = (Button)this.findViewById(2130837514);
        this.statusView = (TextView)this.findViewById(2130837508);
        this.scandataType = (Spinner)this.findViewById(2130837512);
        this.statusView.setText((CharSequence)"\n");
        this.btName.setEnabled(false);
        this.btAddress.setEnabled(false);
        EMDKResults results = EMDKManager.getEMDKManager((Context)this.getApplicationContext(), (EMDKManager.EMDKListener)this);
        if (results.statusCode == EMDKResults.STATUS_CODE.SUCCESS) {
            this.statusView.setText((CharSequence)"Please wait, initialization in progress...");
        } else {
            this.statusView.setText((CharSequence)"Initialization failed!");
        }
        ArrayList<ScanAndPairConfig.ScanDataType> scanDataTypes = new ArrayList<ScanAndPairConfig.ScanDataType>();
        scanDataTypes.add(ScanAndPairConfig.ScanDataType.MAC_ADDRESS);
        scanDataTypes.add(ScanAndPairConfig.ScanDataType.DEVICE_NAME);
        scanDataTypes.add(ScanAndPairConfig.ScanDataType.UNSPECIFIED);
        ArrayAdapter arrayAdapter = new ArrayAdapter(this.getApplicationContext(), 2130903041, scanDataTypes);
        this.scandataType.setAdapter((SpinnerAdapter)arrayAdapter);
        this.registerForButtonEvents();
        this.addCheckBoxListener();
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.emdkManager != null) {
            this.emdkManager.release();
            this.emdkManager = null;
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(2130968576, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 2130837504) {
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onOpened(EMDKManager emdkManager) {
        this.emdkManager = emdkManager;
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                MainActivity.this.statusView.setText((CharSequence)"Application Initialized.");
            }
        });
    }

    public void onClosed() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                MainActivity.this.statusView.setText((CharSequence)"Error!! Restart the application!!");
            }
        });
    }

    private void addCheckBoxListener() {
        this.checkBoxAlwaysScan.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (isChecked) {
                    MainActivity.this.btName.setEnabled(false);
                    MainActivity.this.btAddress.setEnabled(false);
                } else {
                    MainActivity.this.btName.setEnabled(true);
                    MainActivity.this.btAddress.setEnabled(true);
                }
            }
        });
    }

    private void registerForButtonEvents() {
        this.addScanAndPairButtonEvents();
        this.addScanAndUnpairButtonEvents();
    }

    private void addScanAndPairButtonEvents() {
        this.scanAndPairButton = (Button)this.findViewById(2130837513);
        this.scanAndPairButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    MainActivity.this.statusView.setText((CharSequence)"ScanAndPair started...\n");
                    if (MainActivity.this.scanAndPairMgr == null) {
                        MainActivity.this.scanAndPairMgr = (ScanAndPairManager)MainActivity.this.emdkManager.getInstance(EMDKManager.FEATURE_TYPE.SCANANDPAIR);
                        if (MainActivity.this.scanAndPairMgr != null) {
                            MainActivity.this.scanAndPairMgr.addStatusListener(MainActivity.this.statusCallbackObj);
                        }
                    }
                    if (MainActivity.this.scanAndPairMgr != null) {
                        MainActivity.this.scanAndPairMgr.config.alwaysScan = MainActivity.this.checkBoxAlwaysScan.isChecked();
                        MainActivity.this.scanAndPairMgr.config.notificationType = ScanAndPairConfig.NotificationType.BEEPER;
                        if (!MainActivity.this.checkBoxAlwaysScan.isChecked()) {
                            MainActivity.this.scanAndPairMgr.config.bluetoothInfo.macAddress = MainActivity.this.btAddress.getText().toString().trim();
                            MainActivity.this.scanAndPairMgr.config.bluetoothInfo.deviceName = MainActivity.this.btName.getText().toString().trim();
                        } else {
                            MainActivity.this.scanAndPairMgr.config.scanInfo.scanTimeout = 5000;
                            MainActivity.this.scanAndPairMgr.config.scanInfo.triggerType = MainActivity.this.checkboxHardTrigger.isChecked() ? ScanAndPairConfig.TriggerType.HARD : ScanAndPairConfig.TriggerType.SOFT;
                            MainActivity.this.scanAndPairMgr.config.scanInfo.scanDataType = (ScanAndPairConfig.ScanDataType)MainActivity.this.scandataType.getSelectedItem();
                        }
                        ScanAndPairResults resultCode = MainActivity.this.scanAndPairMgr.scanAndPair("0000");
                        if (!resultCode.equals((Object)ScanAndPairResults.SUCCESS)) {
                            MainActivity.this.statusView.append((CharSequence)(resultCode.toString() + "\n\n"));
                        }
                    } else {
                        MainActivity.this.statusView.append((CharSequence)"ScanAndPairmanager intialization failed!");
                    }
                }
                catch (Exception e) {
                    MainActivity.this.statusView.setText((CharSequence)("ScanAndUnpair Error:" + e.getMessage() + "\n"));
                }
            }
        });
    }

    private void addScanAndUnpairButtonEvents() {
        this.scanAndUnpairButton = (Button)this.findViewById(2130837514);
        this.scanAndUnpairButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    MainActivity.this.statusView.setText((CharSequence)"ScanAndUnpair started...\n");
                    if (MainActivity.this.scanAndPairMgr == null) {
                        MainActivity.this.scanAndPairMgr = (ScanAndPairManager)MainActivity.this.emdkManager.getInstance(EMDKManager.FEATURE_TYPE.SCANANDPAIR);
                        if (MainActivity.this.scanAndPairMgr != null) {
                            MainActivity.this.scanAndPairMgr.addStatusListener(MainActivity.this.statusCallbackObj);
                        }
                    }
                    if (MainActivity.this.scanAndPairMgr != null) {
                        MainActivity.this.scanAndPairMgr.config.alwaysScan = MainActivity.this.checkBoxAlwaysScan.isChecked();
                        MainActivity.this.scanAndPairMgr.config.notificationType = ScanAndPairConfig.NotificationType.BEEPER;
                        if (!MainActivity.this.checkBoxAlwaysScan.isChecked()) {
                            MainActivity.this.scanAndPairMgr.config.bluetoothInfo.macAddress = MainActivity.this.btAddress.getText().toString().trim();
                            MainActivity.this.scanAndPairMgr.config.bluetoothInfo.deviceName = MainActivity.this.btName.getText().toString().trim();
                        } else {
                            MainActivity.this.scanAndPairMgr.config.scanInfo.scanTimeout = 5000;
                            MainActivity.this.scanAndPairMgr.config.scanInfo.triggerType = MainActivity.this.checkboxHardTrigger.isChecked() ? ScanAndPairConfig.TriggerType.HARD : ScanAndPairConfig.TriggerType.SOFT;
                            MainActivity.this.scanAndPairMgr.config.scanInfo.scanDataType = (ScanAndPairConfig.ScanDataType)MainActivity.this.scandataType.getSelectedItem();
                        }
                        ScanAndPairResults resultCode = MainActivity.this.scanAndPairMgr.scanAndUnpair();
                        if (!resultCode.equals((Object)ScanAndPairResults.SUCCESS)) {
                            MainActivity.this.statusView.append((CharSequence)(resultCode.toString() + "\n\n"));
                        }
                    } else {
                        MainActivity.this.statusView.append((CharSequence)"ScanAndPairmanager intialization failed!");
                    }
                }
                catch (Exception e) {
                    MainActivity.this.statusView.setText((CharSequence)("ScanAndUnpair Error:" + e.getMessage() + "\n"));
                }
            }
        });
    }

    public void onStatus(StatusData statusData) {
        final StringBuilder text = new StringBuilder();
        boolean isUpdateAddress = false;
        switch (statusData.getState()) {
            case WAITING: {
                text.append("Waiting for trigger press to scan the barcode");
                break;
            }
            case SCANNING: {
                text.append("Scanner Beam is on, aim at the barcode.");
                break;
            }
            case DISCOVERING: {
                text.append("Discovering for the Bluetooth device");
                isUpdateAddress = true;
                break;
            }
            case PAIRED: {
                text.append("Bluetooth device is paired successfully");
                break;
            }
            case UNPAIRED: {
                text.append("Bluetooth device is un-paired successfully");
                break;
            }
            default: {
                text.append("\n" + statusData.getState().toString() + ": " + statusData.getResult());
            }
        }
        final boolean isUpdateUI = isUpdateAddress;
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                MainActivity.this.statusView.setText((CharSequence)(text + "\n"));
                if (isUpdateUI) {
                    MainActivity.this.btName.setText((CharSequence)MainActivity.this.scanAndPairMgr.config.bluetoothInfo.deviceName);
                    MainActivity.this.btAddress.setText((CharSequence)MainActivity.this.scanAndPairMgr.config.bluetoothInfo.macAddress);
                }
            }
        });
    }
}

