/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.udisample1;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.RadioButton;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import com.symbol.emdk.EMDKManager;
import com.symbol.emdk.EMDKResults;
import com.symbol.emdk.barcode.BarcodeManager;
import com.symbol.emdk.barcode.ScanDataCollection;
import com.symbol.emdk.barcode.Scanner;
import com.symbol.emdk.barcode.ScannerConfig;
import com.symbol.emdk.barcode.ScannerException;
import com.symbol.emdk.barcode.ScannerInfo;
import com.symbol.emdk.barcode.ScannerResults;
import com.symbol.emdk.barcode.StatusData;
import com.symbol.emdk.barcode.TokenizedData;
import java.util.ArrayList;
import java.util.List;

public class MainActivity
extends Activity
implements EMDKManager.EMDKListener,
Scanner.DataListener,
Scanner.StatusListener,
BarcodeManager.ScannerConnectionListener {
    private EMDKManager emdkManager = null;
    private BarcodeManager barcodeManager = null;
    private Scanner scanner = null;
    private TextView textViewStatus = null;
    private Spinner spinnerScannerDevices = null;
    private Spinner spinnerTriggers = null;
    private RadioButton radioUDI = null;
    private List<ScannerInfo> deviceList = new ArrayList<ScannerInfo>();
    private String statusString = "";
    private int scannerIndex = 0;
    private int defaultIndex = 0;
    private int triggerIndex = 1;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131034112);
        EMDKResults results = EMDKManager.getEMDKManager((Context)this.getApplicationContext(), (EMDKManager.EMDKListener)this);
        if (results.statusCode != EMDKResults.STATUS_CODE.SUCCESS) {
            this.textViewStatus.setText((CharSequence)"Status: EMDKManager object request failed!");
        }
        this.textViewStatus = (TextView)this.findViewById(2130968585);
        this.spinnerScannerDevices = (Spinner)this.findViewById(2130968579);
        this.spinnerTriggers = (Spinner)this.findViewById(2130968580);
        this.addSpinnerScannerDevicesListener();
        this.addSpinnerTriggersListener();
        this.addStartScanButtonListener();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.deInitScanner();
        if (this.barcodeManager != null) {
            this.barcodeManager.removeConnectionListener((BarcodeManager.ScannerConnectionListener)this);
            this.barcodeManager = null;
        }
        if (this.emdkManager != null) {
            this.emdkManager.release();
            this.emdkManager = null;
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(2131099648, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 2130968576) {
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onOpened(EMDKManager emdkManager) {
        this.textViewStatus.setText((CharSequence)"Status: EMDK open success!");
        this.emdkManager = emdkManager;
        this.barcodeManager = (BarcodeManager)emdkManager.getInstance(EMDKManager.FEATURE_TYPE.BARCODE);
        if (this.barcodeManager != null) {
            this.barcodeManager.addConnectionListener((BarcodeManager.ScannerConnectionListener)this);
        }
        this.enumerateScannerDevices();
        this.spinnerScannerDevices.setSelection(this.defaultIndex);
    }

    public void onClosed() {
        if (this.emdkManager != null) {
            if (this.barcodeManager != null) {
                this.barcodeManager.removeConnectionListener((BarcodeManager.ScannerConnectionListener)this);
                this.barcodeManager = null;
            }
            this.emdkManager.release();
            this.emdkManager = null;
        }
        this.textViewStatus.setText((CharSequence)"Status: EMDK closed unexpectedly! Please close and restart the application.");
    }

    public void onData(ScanDataCollection scanDataCollection) {
        String outString = "\nUDI Data: \n";
        if (scanDataCollection != null && scanDataCollection.getResult() == ScannerResults.SUCCESS) {
            for (ScanDataCollection.ScanData data : scanDataCollection.getScanData()) {
                Log.d((String)"UDISample1", (String)("Data: " + data.getData()));
            }
            if (scanDataCollection.getTokenizedData() != null) {
                ArrayList<TableRow> rows = new ArrayList<TableRow>();
                TableRow row = new TableRow((Context)this);
                row.setBackgroundColor(-16777216);
                row.setPadding(1, 1, 1, 1);
                TableRow.LayoutParams llp = new TableRow.LayoutParams(-1, -1);
                llp.setMargins(0, 0, 2, 0);
                TextView keyText = new TextView((Context)this);
                keyText.setPadding(5, 5, 5, 5);
                keyText.setLayoutParams((ViewGroup.LayoutParams)llp);
                keyText.setBackgroundColor(-1);
                keyText.setText((CharSequence)"Key");
                row.addView((View)keyText);
                TextView valueText = new TextView((Context)this);
                valueText.setPadding(5, 5, 5, 5);
                valueText.setBackgroundColor(-1);
                valueText.setText((CharSequence)"Value");
                row.addView((View)valueText);
                rows.add(row);
                for (TokenizedData.Token data : scanDataCollection.getTokenizedData().getTokens()) {
                    row = new TableRow((Context)this);
                    row.setBackgroundColor(-16777216);
                    row.setPadding(1, 1, 1, 1);
                    String mKey = this.modifyDisplayName(data.getKey());
                    String mValue = data.getData();
                    keyText = new TextView((Context)this);
                    keyText.setPadding(5, 5, 5, 5);
                    keyText.setLayoutParams((ViewGroup.LayoutParams)llp);
                    keyText.setBackgroundColor(-1);
                    keyText.setText((CharSequence)mKey);
                    row.addView((View)keyText);
                    valueText = new TextView((Context)this);
                    valueText.setPadding(5, 5, 5, 5);
                    valueText.setBackgroundColor(-1);
                    valueText.setLayoutParams((ViewGroup.LayoutParams)llp);
                    valueText.setText((CharSequence)mValue);
                    row.addView((View)valueText);
                    rows.add(row);
                }
                new AsyncUDIDataUpdate(rows).execute(new String[]{"Scan type: " + scanDataCollection.getLabelIdentifier()});
            }
        }
    }

    private String modifyDisplayName(String key) {
        switch (key) {
            case "di": {
                key = "DI";
                break;
            }
            case "manufacturing_date_original": {
                key = "MFG Date";
                break;
            }
            case "expiration_date_original": {
                key = "EXP Date";
                break;
            }
            case "lot_number": {
                key = "Lot Number";
                break;
            }
            case "serial_number": {
                key = "Serial Number";
                break;
            }
            case "donation_id": {
                key = "Donation ID";
                break;
            }
            case "mpho_lot_number": {
                key = "Mpho\nLot Number";
                break;
            }
            case "labeler_identification_code": {
                key = "Labeler ID";
                break;
            }
            case "product_or_catalog_number": {
                key = "Product/Catalog\nNumber";
                break;
            }
            case "unit_of_measure_id": {
                key = "UOM ID";
                break;
            }
            case "quantity": {
                key = "Quantity";
            }
        }
        return key;
    }

    public void onStatus(StatusData statusData) {
        StatusData.ScannerStates state = statusData.getState();
        new AsyncStatusUpdate().execute(new String[]{state.toString()});
    }

    private void addSpinnerScannerDevicesListener() {
        this.spinnerScannerDevices.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View arg1, int position, long arg3) {
                if (MainActivity.this.scannerIndex != position || MainActivity.this.scanner == null) {
                    MainActivity.this.scannerIndex = position;
                    MainActivity.this.deInitScanner();
                    MainActivity.this.initScanner();
                    MainActivity.this.setTrigger();
                    MainActivity.this.setConfig();
                }
            }

            public void onNothingSelected(AdapterView<?> arg0) {
            }
        });
    }

    private void addSpinnerTriggersListener() {
        this.spinnerTriggers.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> arg0, View arg1, int position, long arg3) {
                MainActivity.this.triggerIndex = position;
                MainActivity.this.setTrigger();
            }

            public void onNothingSelected(AdapterView<?> arg0) {
            }
        });
    }

    private void addStartScanButtonListener() {
        Button btnStartScan = (Button)this.findViewById(2130968577);
        btnStartScan.setOnClickListener(new View.OnClickListener(){

            public void onClick(View arg0) {
                MainActivity.this.startScan();
            }
        });
    }

    private void enumerateScannerDevices() {
        if (this.barcodeManager != null) {
            ArrayList<String> friendlyNameList = new ArrayList<String>();
            int spinnerIndex = 0;
            this.deviceList = this.barcodeManager.getSupportedDevicesInfo();
            if (this.deviceList != null && this.deviceList.size() != 0) {
                for (ScannerInfo scnInfo : this.deviceList) {
                    friendlyNameList.add(scnInfo.getFriendlyName());
                    if (scnInfo.isDefaultScanner()) {
                        this.defaultIndex = spinnerIndex;
                    }
                    ++spinnerIndex;
                }
            } else {
                this.textViewStatus.setText((CharSequence)"Status: Failed to get the list of supported scanner devices! Please close and restart the application.");
            }
            ArrayAdapter spinnerAdapter = new ArrayAdapter((Context)this, 17367048, friendlyNameList);
            spinnerAdapter.setDropDownViewResource(0x1090009);
            this.spinnerScannerDevices.setAdapter((SpinnerAdapter)spinnerAdapter);
        }
    }

    private void setTrigger() {
        if (this.scanner == null) {
            this.initScanner();
        }
        if (this.scanner != null) {
            switch (this.triggerIndex) {
                case 0: {
                    this.scanner.triggerType = Scanner.TriggerType.HARD;
                    break;
                }
                case 1: {
                    this.scanner.triggerType = Scanner.TriggerType.SOFT_ALWAYS;
                }
            }
        }
    }

    private void setConfig() {
        if (this.scanner == null) {
            this.initScanner();
        }
        if (this.scanner != null && this.scanner.isEnabled()) {
            try {
                ScannerConfig config = this.scanner.getConfig();
                config.readerParams.readerSpecific.imagerSpecific.scanMode = ScannerConfig.ScanMode.UDI;
                config.udiParams.enableGS1 = true;
                config.udiParams.enableHIBCC = true;
                config.udiParams.enableICCBBA = true;
                this.scanner.setConfig(config);
            }
            catch (ScannerException e) {
                this.textViewStatus.setText((CharSequence)("Status: " + e.getMessage()));
            }
        }
    }

    private void startScan() {
        if (this.scanner == null) {
            this.initScanner();
        }
        if (this.scanner != null) {
            try {
                if (this.scanner.isEnabled()) {
                    this.scanner.read();
                } else {
                    this.textViewStatus.setText((CharSequence)"Status: Scanner is not enabled");
                }
            }
            catch (ScannerException e) {
                this.textViewStatus.setText((CharSequence)("Status: " + e.getMessage()));
            }
        }
    }

    private void initScanner() {
        if (this.scanner == null) {
            if (this.deviceList == null || this.deviceList.size() == 0) {
                this.textViewStatus.setText((CharSequence)"Status: Failed to get the specified scanner device! Please close and restart the application.");
                return;
            }
            this.scanner = this.barcodeManager.getDevice(this.deviceList.get(this.scannerIndex));
            if (this.scanner != null) {
                this.scanner.addDataListener((Scanner.DataListener)this);
                this.scanner.addStatusListener((Scanner.StatusListener)this);
                try {
                    this.scanner.enable();
                }
                catch (ScannerException e) {
                    this.textViewStatus.setText((CharSequence)("Status: " + e.getMessage()));
                }
            } else {
                this.textViewStatus.setText((CharSequence)"Status: Failed to initialize the scanner device.");
            }
        }
    }

    private void deInitScanner() {
        if (this.scanner != null) {
            try {
                this.scanner.cancelRead();
                this.scanner.disable();
            }
            catch (Exception e) {
                this.textViewStatus.setText((CharSequence)("Status: " + e.getMessage()));
            }
            try {
                this.scanner.removeDataListener((Scanner.DataListener)this);
                this.scanner.removeStatusListener((Scanner.StatusListener)this);
            }
            catch (Exception e) {
                this.textViewStatus.setText((CharSequence)("Status: " + e.getMessage()));
            }
            try {
                this.scanner.release();
            }
            catch (Exception e) {
                this.textViewStatus.setText((CharSequence)("Status: " + e.getMessage()));
            }
            this.scanner = null;
        }
    }

    public void onConnectionChange(ScannerInfo scannerInfo, BarcodeManager.ConnectionState connectionState) {
        String scannerName = "";
        String statusExtScanner = connectionState.toString();
        String scannerNameExtScanner = scannerInfo.getFriendlyName();
        if (this.deviceList.size() != 0) {
            scannerName = this.deviceList.get(this.scannerIndex).getFriendlyName();
        }
        if (scannerName.equalsIgnoreCase(scannerNameExtScanner)) {
            switch (connectionState) {
                case CONNECTED: {
                    this.deInitScanner();
                    this.initScanner();
                    this.setTrigger();
                    this.setConfig();
                    break;
                }
                case DISCONNECTED: {
                    this.deInitScanner();
                }
            }
            String status = scannerNameExtScanner + ":" + statusExtScanner;
            new AsyncStatusUpdate().execute(new String[]{status});
        } else {
            String status = this.statusString + " " + scannerNameExtScanner + ":" + statusExtScanner;
            new AsyncStatusUpdate().execute(new String[]{status});
        }
    }

    private class AsyncUDIDataUpdate
    extends AsyncTask<String, Void, String> {
        private ArrayList<TableRow> rows;

        AsyncUDIDataUpdate(ArrayList<TableRow> rows) {
            this.rows = rows;
        }

        protected String doInBackground(String ... params) {
            return params[0];
        }

        protected void onPostExecute(String decodeType) {
            TextView tv = (TextView)MainActivity.this.findViewById(2130968586);
            tv.setText((CharSequence)decodeType);
            TableLayout tl = (TableLayout)MainActivity.this.findViewById(2130968581);
            tl.removeAllViews();
            for (TableRow row : this.rows) {
                tl.addView((View)row);
            }
        }
    }

    private class AsyncStatusUpdate
    extends AsyncTask<String, Void, String> {
        private AsyncStatusUpdate() {
        }

        protected String doInBackground(String ... params) {
            return params[0];
        }

        protected void onPostExecute(String result) {
            MainActivity.this.textViewStatus.setText((CharSequence)("Status: " + result));
        }
    }
}

