/*
 * Decompiled with CFR 0.152.
 */
package com.symbol.profilewifisample1;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Xml;
import android.view.Menu;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RadioGroup;
import android.widget.Spinner;
import android.widget.TextView;
import com.symbol.emdk.EMDKManager;
import com.symbol.emdk.EMDKResults;
import com.symbol.emdk.ProfileManager;
import java.io.Reader;
import java.io.StringReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MainActivity
extends Activity
implements EMDKManager.EMDKListener {
    private String profileName = "WifiProfile-1";
    private ProfileManager profileManager = null;
    private EMDKManager emdkManager = null;
    private TextView statusTextView = null;
    private String SSID = "";
    private String errorType = "";
    private String parmName = "";
    private String errorDescription = "";
    private String errorString = "";
    private Action action = Action.ADD;
    private RadioState radioState = RadioState.ENABLE;
    private String[] ActionStrings = new String[]{"Do Nothing", "Add", "Remove", "Connect", "Disconnect", "Enable", "Disable"};
    private String[] RadioStateStrings = new String[]{"enable", "disable"};

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2130968576);
        this.statusTextView = (TextView)this.findViewById(2130903052);
        this.addSetButtonListener();
        EMDKResults results = EMDKManager.getEMDKManager((Context)this.getApplicationContext(), (EMDKManager.EMDKListener)this);
        if (results.statusCode == EMDKResults.STATUS_CODE.SUCCESS) {
            // empty if block
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.profileManager != null) {
            this.profileManager = null;
        }
        if (this.emdkManager != null) {
            this.emdkManager.release();
            this.emdkManager = null;
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(2131034112, menu2);
        return true;
    }

    public void onClosed() {
        if (this.emdkManager != null) {
            this.emdkManager.release();
            this.emdkManager = null;
        }
        this.statusTextView.setText((CharSequence)"Status: EMDK closed unexpectedly! Please close and restart the application.");
    }

    public void onOpened(EMDKManager emdkManager) {
        this.statusTextView.setText((CharSequence)"EMDK open success.");
        this.emdkManager = emdkManager;
        this.profileManager = (ProfileManager)emdkManager.getInstance(EMDKManager.FEATURE_TYPE.PROFILE);
    }

    private void addSetButtonListener() {
        Button setButton = (Button)this.findViewById(2130903041);
        setButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View arg0) {
                if (MainActivity.this.readValues()) {
                    MainActivity.this.modifyProfile_XMLString();
                } else {
                    MainActivity.this.statusTextView.setText((CharSequence)"The SSID field cannot be empty.");
                }
            }
        });
    }

    private boolean readValues() {
        Spinner spinner = (Spinner)this.findViewById(2130903047);
        this.action = Action.values()[spinner.getSelectedItemPosition()];
        EditText SSIDEditText = (EditText)this.findViewById(2130903042);
        this.SSID = SSIDEditText.getText().toString().trim();
        if (this.action != Action.DO_NOTHING && (this.SSID == null || this.SSID.length() == 0)) {
            return false;
        }
        RadioGroup radiogroup = (RadioGroup)this.findViewById(2130903046);
        this.radioState = 2130903044 == radiogroup.getCheckedRadioButtonId() ? RadioState.ENABLE : RadioState.DISABLE;
        return true;
    }

    private void modifyProfile_XMLString() {
        this.statusTextView.setText((CharSequence)"");
        this.errorType = "";
        this.parmName = "";
        this.errorDescription = "";
        this.errorString = "";
        String[] modifyData = new String[]{"<?xml version=\"1.0\" encoding=\"utf-8\"?><characteristic type=\"Profile\"><parm name=\"ProfileName\" value=\"WifiProfile-1\"/><characteristic type=\"Wi-Fi\" version=\"2.7\"><characteristic type=\"System\"><parm name=\"WiFiAction\" value=\"" + this.RadioStateStrings[this.radioState.ordinal()] + "\"/></characteristic>"};
        if (this.action != Action.DO_NOTHING) {
            modifyData[0] = modifyData[0] + "<parm name=\"NetworkAction\" value=\"" + this.ActionStrings[this.action.ordinal()] + "\"/><characteristic type=\"network-profile\"><parm name=\"SSID\" value=\"" + this.SSID + "\"/>";
            switch (this.action) {
                case ADD: {
                    modifyData[0] = modifyData[0] + "<parm name=\"SecurityMode\" value=\"0\"/><parm name=\"UseDHCP\" value=\"1\"/><parm name=\"UseProxy\" value=\"0\"/>";
                }
            }
            modifyData[0] = modifyData[0] + "</characteristic>";
        }
        modifyData[0] = modifyData[0] + "</characteristic></characteristic>";
        new ProcessProfileTask().execute(new String[]{modifyData[0]});
    }

    public void parseXML(XmlPullParser myParser) {
        try {
            int event = myParser.getEventType();
            while (event != 1) {
                String name = myParser.getName();
                switch (event) {
                    case 2: {
                        if (name.equals("parm-error")) {
                            this.parmName = myParser.getAttributeValue(null, "name");
                            this.errorDescription = myParser.getAttributeValue(null, "desc");
                            this.errorString = " (Name: " + this.parmName + ", Error Description: " + this.errorDescription + ")";
                            return;
                        }
                        if (!name.equals("characteristic-error")) break;
                        this.errorType = myParser.getAttributeValue(null, "type");
                        this.errorDescription = myParser.getAttributeValue(null, "desc");
                        this.errorString = " (Type: " + this.errorType + ", Error Description: " + this.errorDescription + ")";
                        return;
                    }
                }
                event = myParser.next();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static enum Action {
        DO_NOTHING,
        ADD,
        REMOVE,
        CONNECT,
        DISCONNECT,
        ENABLE,
        DISABLE;

    }

    private static enum RadioState {
        ENABLE,
        DISABLE;

    }

    private class ProcessProfileTask
    extends AsyncTask<String, Void, EMDKResults> {
        private ProcessProfileTask() {
        }

        protected EMDKResults doInBackground(String ... params) {
            EMDKResults results = MainActivity.this.profileManager.processProfile(MainActivity.this.profileName, ProfileManager.PROFILE_FLAG.SET, params);
            return results;
        }

        protected void onPostExecute(EMDKResults results) {
            super.onPostExecute((Object)results);
            String resultString = "";
            if (results.statusCode == EMDKResults.STATUS_CODE.CHECK_XML) {
                String statusXMLResponse = results.getStatusString();
                try {
                    XmlPullParser parser = Xml.newPullParser();
                    parser.setInput((Reader)new StringReader(statusXMLResponse));
                    MainActivity.this.parseXML(parser);
                    resultString = TextUtils.isEmpty((CharSequence)MainActivity.this.parmName) && TextUtils.isEmpty((CharSequence)MainActivity.this.errorType) && TextUtils.isEmpty((CharSequence)MainActivity.this.errorDescription) ? "Profile update success." : "Profile update failed." + MainActivity.this.errorString;
                }
                catch (XmlPullParserException e) {
                    resultString = e.getMessage();
                }
            }
            MainActivity.this.statusTextView.setText((CharSequence)resultString);
        }
    }
}

